/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.KillSwitch;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import software.amazon.codeguruprofilerjavaagent.Timer;

abstract class ProfilingCommandExecutor
implements ProfilingCommands {
    private static final Logger LOG = Logger.getLogger(ProfilingCommandExecutor.class.getName());
    protected ScheduledExecutorService executor;
    protected ScheduledFuture<?> futureSampleTask;
    protected volatile boolean isTerminated = false;
    protected final Timer overheadTimer = new Timer();
    protected final KillSwitch killSwitch = new KillSwitch();

    @Override
    public void run() {
        this.overheadTimer.time(this::startSampling, Timer.ProfilingTimes.runProfiler);
    }

    @Override
    public void scheduleProfiling() {
        if (this.isTerminated) {
            LOG.info("ProfilingCommand cannot be started again, create another instance instead");
            return;
        }
        if (this.isProfilingDisabled()) {
            return;
        }
        this.setProfilingScheduledExecutor();
        Duration samplingInterval = this.getParameters().getSamplingInterval();
        this.scheduleTaskInExecutor(samplingInterval, samplingInterval);
        LOG.info("Profiling scheduled, sampling rate is " + samplingInterval);
    }

    private void setProfilingScheduledExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread = new Thread(r, "Amazon-Profiler");
                thread.setDaemon(true);
                thread.interrupt();
                return thread;
            });
        }
    }

    @Override
    public void stopProfiling() {
        this.isTerminated = true;
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "InterruptedException received while waiting for executor to terminate.");
            }
            finally {
                this.futureSampleTask = null;
                this.executor = null;
            }
        }
        this.overheadTimer.time(() -> this.flush(true), Timer.ProfilingTimes.flush);
    }

    @Override
    public CompletableFuture<Void> asyncStopProfiling() {
        this.isTerminated = true;
        return CompletableFuture.runAsync(this::stopProfiling);
    }

    @Override
    public boolean isProfilingScheduled() {
        return this.executor != null && !this.isTerminated;
    }

    protected final void scheduleTaskInExecutor(Duration initialDelay, Duration delay) {
        if (this.executor != null) {
            this.cancelTaskInExecutor();
            this.futureSampleTask = this.executor.scheduleWithFixedDelay(this, initialDelay.toNanos(), delay.toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    protected final void cancelTaskInExecutor() {
        if (this.futureSampleTask != null) {
            this.futureSampleTask.cancel(false);
            this.futureSampleTask = null;
        }
    }

    protected final void waitAndCancelTaskInExecutor(long waitTimeInMs) {
        if (this.futureSampleTask != null) {
            try {
                this.futureSampleTask.get(waitTimeInMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Exception received while waiting for task to complete.", e);
            }
            finally {
                this.cancelTaskInExecutor();
            }
        }
    }

    private boolean isProfilingDisabled() {
        if (this.killSwitch.isKillSwitchOn(true)) {
            LOG.info("Disabling the profiler as the kill switch file has been found");
            return true;
        }
        return false;
    }

    abstract void flush(boolean var1);

    abstract ProfilerParameters getParameters();

    abstract ProfilerFinalParameters getFinalParameters();
}

