/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.util;

import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import software.amazon.cloudwatchlogs.emf.Constants;
import software.amazon.cloudwatchlogs.emf.exception.InvalidDimensionException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidMetricException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidNamespaceException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidTimestampException;
import software.amazon.cloudwatchlogs.emf.model.Unit;

public class Validator {
    private Validator() {
        throw new IllegalStateException("Utility class");
    }

    public static void validateDimensionSet(String dimensionName, String dimensionValue) throws InvalidDimensionException {
        if (dimensionName == null || dimensionName.trim().isEmpty()) {
            throw new InvalidDimensionException("Dimension name cannot be empty");
        }
        if (dimensionValue == null || dimensionValue.trim().isEmpty()) {
            throw new InvalidDimensionException("Dimension value cannot be empty");
        }
        if (dimensionName.length() > 250) {
            throw new InvalidDimensionException("Dimension name exceeds maximum length of 250: " + dimensionName);
        }
        if (dimensionValue.length() > 1024) {
            throw new InvalidDimensionException("Dimension value exceeds maximum length of 1024: " + dimensionValue);
        }
        if (!StringUtils.isAsciiPrintable((CharSequence)dimensionName)) {
            throw new InvalidDimensionException("Dimension name has invalid characters: " + dimensionName);
        }
        if (!StringUtils.isAsciiPrintable((CharSequence)dimensionValue)) {
            throw new InvalidDimensionException("Dimension value has invalid characters: " + dimensionValue);
        }
        if (dimensionName.startsWith(":")) {
            throw new InvalidDimensionException("Dimension name cannot start with ':'");
        }
    }

    public static void validateMetric(String name, double value, Unit unit) throws InvalidMetricException {
        if (name == null || name.trim().isEmpty()) {
            throw new InvalidMetricException("Metric name " + name + " must include at least one non-whitespace character");
        }
        if (name.length() > 1024) {
            throw new InvalidMetricException("Metric name exceeds maximum length of 1024: " + name);
        }
        if (!Double.isFinite(value)) {
            throw new InvalidMetricException("Metric value is not a number");
        }
        if (unit == null) {
            throw new InvalidMetricException("Metric unit cannot be null");
        }
    }

    public static void validateNamespace(String namespace) throws InvalidNamespaceException {
        if (namespace == null || namespace.trim().isEmpty()) {
            throw new InvalidNamespaceException("Namespace must include at least one non-whitespace character");
        }
        if (namespace.length() > 256) {
            throw new InvalidNamespaceException("Namespace exceeds maximum length of 256: " + namespace);
        }
        if (!namespace.matches("^[a-zA-Z0-9._#:/-]+$")) {
            throw new InvalidNamespaceException("Namespace contains invalid characters: " + namespace);
        }
    }

    public static void validateTimestamp(Instant timestamp) throws InvalidTimestampException {
        if (timestamp == null) {
            throw new InvalidTimestampException("Timestamp cannot be null");
        }
        if (timestamp.isAfter(Instant.now().plusSeconds(Constants.MAX_TIMESTAMP_FUTURE_AGE_SECONDS))) {
            throw new InvalidTimestampException("Timestamp cannot be more than " + Constants.MAX_TIMESTAMP_FUTURE_AGE_SECONDS + " seconds in the future");
        }
        if (timestamp.isBefore(Instant.now().minusSeconds(Constants.MAX_TIMESTAMP_PAST_AGE_SECONDS))) {
            throw new InvalidTimestampException("Timestamp cannot be more than " + Constants.MAX_TIMESTAMP_PAST_AGE_SECONDS + " seconds in the past");
        }
    }
}

