/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.sinks.Protocol;

public class Endpoint {
    private static final Logger log = LoggerFactory.getLogger(Endpoint.class);
    public static final Endpoint DEFAULT_TCP_ENDPOINT = new Endpoint("127.0.0.1", 25888, Protocol.TCP);
    @NonNull
    private final String host;
    private final int port;
    @NonNull
    private final Protocol protocol;

    public static Endpoint fromURL(String endpoint) {
        Protocol protocol;
        URI parsedURI = null;
        try {
            parsedURI = new URI(endpoint);
        }
        catch (URISyntaxException ex) {
            log.warn("Failed to parse the endpoint: {} ", (Object)endpoint);
            return DEFAULT_TCP_ENDPOINT;
        }
        if (parsedURI.getHost() == null || parsedURI.getPort() < 0 || parsedURI.getScheme() == null) {
            return DEFAULT_TCP_ENDPOINT;
        }
        try {
            protocol = Protocol.getProtocol(parsedURI.getScheme());
        }
        catch (IllegalArgumentException e) {
            log.warn("Unsupported protocol: {}. Would use default endpoint: {}", (Object)parsedURI.getScheme(), (Object)DEFAULT_TCP_ENDPOINT);
            return DEFAULT_TCP_ENDPOINT;
        }
        return new Endpoint(parsedURI.getHost(), parsedURI.getPort(), protocol);
    }

    public String toString() {
        return this.protocol.toString().toLowerCase() + "://" + this.host + ":" + this.port;
    }

    public Endpoint(@NonNull String host, int port, @NonNull Protocol protocol) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public Protocol getProtocol() {
        return this.protocol;
    }
}

