/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.exception.EMFClientException;
import software.amazon.cloudwatchlogs.emf.util.IOUtils;
import software.amazon.cloudwatchlogs.emf.util.Jackson;

public class ResourceFetcher {
    private static final Logger log = LoggerFactory.getLogger(ResourceFetcher.class);

    <T> T fetch(URI endpoint, Class<T> clazz) {
        String response = this.doReadResource(endpoint, "GET", Collections.emptyMap());
        return Jackson.fromJsonString(response, clazz);
    }

    <T> T fetch(URI endpoint, String method, Class<T> clazz, Map<String, String> headers) {
        String response = this.doReadResource(endpoint, method, headers);
        return Jackson.fromJsonString(response, clazz);
    }

    String fetch(URI endpoint, String method, Map<String, String> headers) {
        return this.doReadResource(endpoint, method, headers);
    }

    <T> T fetch(URI endpoint, ObjectMapper objectMapper, Class<T> clazz) {
        String response = this.doReadResource(endpoint, "GET", Collections.emptyMap());
        return Jackson.fromJsonString(response, objectMapper, clazz);
    }

    private String doReadResource(URI endpoint, String method, Map<String, String> headers) {
        int statusCode;
        HttpURLConnection connection;
        InputStream inputStream;
        block6: {
            inputStream = null;
            connection = this.connectToEndpoint(endpoint, method, headers);
            statusCode = connection.getResponseCode();
            if (statusCode != 200) break block6;
            inputStream = connection.getInputStream();
            String string = IOUtils.toString(inputStream);
            IOUtils.closeQuietly(inputStream, log);
            return string;
        }
        try {
            if (statusCode == 404) {
                throw new EMFClientException("The requested metadata is not found at " + connection.getURL());
            }
            inputStream = connection.getErrorStream();
            this.handleErrorResponse(inputStream, connection.getResponseMessage());
        }
        catch (IOException ioException) {
            try {
                log.debug("An IOException occurred when connecting to service endpoint: " + endpoint + "\n Retrying to connect again.");
                throw new EMFClientException("Failed to connect to service endpoint: ", ioException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, log);
        return "";
    }

    private void handleErrorResponse(InputStream errorStream, String responseMessage) throws IOException {
        String errorCode = null;
        if (errorStream != null) {
            String errorResponse = IOUtils.toString(errorStream);
            try {
                JsonNode node = Jackson.jsonNodeOf(errorResponse);
                JsonNode code = node.get("code");
                JsonNode message = node.get("message");
                if (code != null && message != null) {
                    errorCode = code.asText();
                    responseMessage = message.asText();
                }
                String exceptionMessage = String.format("Failed to get resource. Error code: %s, error message: %s ", errorCode, responseMessage);
                throw new EMFClientException(exceptionMessage);
            }
            catch (Exception exception) {
                throw new EMFClientException("Unable to parse error stream: ", exception);
            }
        }
    }

    private HttpURLConnection connectToEndpoint(URI endpoint, String method, Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)endpoint.toURL().openConnection(Proxy.NO_PROXY);
        connection.setConnectTimeout(1000);
        connection.setReadTimeout(1000);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.connect();
        return connection;
    }
}

