/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.sinks.ConsoleSink;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

class LocalEnvironment
implements Environment {
    private static final Logger log = LoggerFactory.getLogger(LocalEnvironment.class);
    private ISink sink;
    private Configuration config;

    LocalEnvironment(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean probe() {
        return false;
    }

    @Override
    public String getName() {
        if (this.config.getServiceName().isPresent()) {
            return this.config.getServiceName().get();
        }
        log.info("Unknown name");
        return "Unknown";
    }

    @Override
    public String getType() {
        if (this.config.getServiceType().isPresent()) {
            return this.config.getServiceType().get();
        }
        log.info("Unknown type");
        return "Unknown";
    }

    @Override
    public String getLogGroupName() {
        return this.config.getLogGroupName().orElse(this.getName() + "-metrics");
    }

    @Override
    public void configureContext(MetricsContext context) {
    }

    @Override
    public ISink getSink() {
        if (this.sink == null) {
            this.sink = new ConsoleSink();
        }
        return this.sink;
    }
}

