/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.config;

import java.util.Optional;
import software.amazon.cloudwatchlogs.emf.environment.Environments;
import software.amazon.cloudwatchlogs.emf.util.StringUtils;

public class Configuration {
    private String serviceName;
    private String serviceType;
    private String logGroupName;
    private String logStreamName;
    private String agentEndpoint;
    Environments environmentOverride;

    public Optional<String> getServiceName() {
        return this.getStringOptional(this.serviceName);
    }

    public Optional<String> getServiceType() {
        return this.getStringOptional(this.serviceType);
    }

    public Optional<String> getLogGroupName() {
        return this.getStringOptional(this.logGroupName);
    }

    public Optional<String> getLogStreamName() {
        return this.getStringOptional(this.logStreamName);
    }

    public Optional<String> getAgentEndpoint() {
        return this.getStringOptional(this.agentEndpoint);
    }

    public Environments getEnvironmentOverride() {
        if (this.environmentOverride == null) {
            return Environments.Unknown;
        }
        return this.environmentOverride;
    }

    private Optional<String> getStringOptional(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public Configuration(String serviceName, String serviceType, String logGroupName, String logStreamName, String agentEndpoint, Environments environmentOverride) {
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.agentEndpoint = agentEndpoint;
        this.environmentOverride = environmentOverride;
    }

    public Configuration() {
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public void setAgentEndpoint(String agentEndpoint) {
        this.agentEndpoint = agentEndpoint;
    }

    public void setEnvironmentOverride(Environments environmentOverride) {
        this.environmentOverride = environmentOverride;
    }
}

