/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import java.util.Optional;
import software.amazon.cloudwatchlogs.emf.config.SystemWrapper;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.sinks.ConsoleSink;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

class LambdaEnvironment
implements Environment {
    private static final String AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private static final String LAMBDA_FUNCTION_NAME = "AWS_LAMBDA_FUNCTION_NAME";
    private static final String LAMBDA_FUNCTION_VERSION = "AWS_LAMBDA_FUNCTION_VERSION";
    private static final String LAMBDA_LOG_STREAM = "AWS_LAMBDA_LOG_STREAM_NAME";
    private static final String TRACE_ID = "_X_AMZN_TRACE_ID";
    private static final String LAMBDA_CFN_NAME = "AWS::Lambda::Function";
    private ISink sink = null;

    LambdaEnvironment() {
    }

    @Override
    public boolean probe() {
        String functionName = this.getEnv(LAMBDA_FUNCTION_NAME);
        return functionName != null;
    }

    @Override
    public String getName() {
        String functionName = this.getEnv(LAMBDA_FUNCTION_NAME);
        return functionName != null ? functionName : "Unknown";
    }

    @Override
    public String getType() {
        return LAMBDA_CFN_NAME;
    }

    @Override
    public String getLogGroupName() {
        return this.getName();
    }

    @Override
    public void configureContext(MetricsContext context) {
        this.addProperty(context, "executionEnvironment", this.getEnv(AWS_EXECUTION_ENV));
        this.addProperty(context, "functionVersion", this.getEnv(LAMBDA_FUNCTION_VERSION));
        this.addProperty(context, "logStreamId", this.getEnv(LAMBDA_LOG_STREAM));
        this.getSampledTrace().ifPresent(traceId -> this.addProperty(context, "traceId", (String)traceId));
    }

    @Override
    public ISink getSink() {
        if (this.sink == null) {
            this.sink = new ConsoleSink();
        }
        return this.sink;
    }

    private void addProperty(MetricsContext context, String key, String value) {
        if (value != null) {
            context.putProperty(key, value);
        }
    }

    private Optional<String> getSampledTrace() {
        String traceId = this.getEnv(TRACE_ID);
        if (traceId != null && traceId.contains("Sampled=1")) {
            return Optional.of(traceId);
        }
        return Optional.empty();
    }

    private String getEnv(String name) {
        return SystemWrapper.getenv(name);
    }
}

