/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.everit.json.schema.JSONPointer;
import org.everit.json.schema.JSONPointerException;
import org.everit.json.schema.PublicJSONPointer;
import org.everit.json.schema.Schema;
import org.json.JSONObject;
import software.amazon.cloudformation.resource.Validator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class ResourceTypeSchema {
    private static final Validator VALIDATOR = new Validator();
    private final Map<String, Object> unprocessedProperties = new HashMap<String, Object>();
    private final String sourceUrl;
    private final String documentationUrl;
    private final String typeName;
    private final String schemaUrl;
    private final List<JSONPointer> createOnlyProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> deprecatedProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> primaryIdentifier = new ArrayList<JSONPointer>();
    private final List<List<JSONPointer>> additionalIdentifiers = new ArrayList<List<JSONPointer>>();
    private final List<JSONPointer> readOnlyProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> writeOnlyProperties = new ArrayList<JSONPointer>();
    private final Schema schema;

    public ResourceTypeSchema(Schema schema) {
        this.schema = schema;
        schema.getUnprocessedProperties().forEach(this.unprocessedProperties::put);
        this.sourceUrl = this.unprocessedProperties.containsKey("sourceUrl") ? this.unprocessedProperties.get("sourceUrl").toString() : null;
        this.unprocessedProperties.remove("sourceUrl");
        this.documentationUrl = this.unprocessedProperties.containsKey("documentationUrl") ? this.unprocessedProperties.get("documentationUrl").toString() : null;
        this.unprocessedProperties.remove("documentationUrl");
        this.typeName = this.unprocessedProperties.get("typeName").toString();
        this.unprocessedProperties.remove("typeName");
        this.schemaUrl = this.unprocessedProperties.containsKey("$schema") ? this.unprocessedProperties.get("$schema").toString() : null;
        this.unprocessedProperties.remove("$schema");
        this.unprocessedProperties.computeIfPresent("createOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.createOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("deprecatedProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.deprecatedProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("primaryIdentifier", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.primaryIdentifier.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("additionalIdentifiers", (k, v) -> {
            ((ArrayList)v).forEach(p -> {
                ArrayList identifiers = new ArrayList();
                ((ArrayList)p).forEach(pi -> identifiers.add(new JSONPointer(pi.toString())));
                this.additionalIdentifiers.add(identifiers);
            });
            return null;
        });
        this.unprocessedProperties.computeIfPresent("readOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.readOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("writeOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.writeOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
    }

    public static ResourceTypeSchema load(JSONObject resourceDefinition) {
        Schema schema = VALIDATOR.loadResourceDefinitionSchema(resourceDefinition);
        return new ResourceTypeSchema(schema);
    }

    public String getDescription() {
        return this.schema.getDescription();
    }

    public List<String> getCreateOnlyPropertiesAsStrings() throws ValidationException {
        return this.createOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getDeprecatedPropertiesAsStrings() throws ValidationException {
        return this.deprecatedProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getPrimaryIdentifierAsStrings() throws ValidationException {
        return this.primaryIdentifier.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<List<String>> getAdditionalIdentifiersAsStrings() throws ValidationException {
        ArrayList<List<String>> identifiers = new ArrayList<List<String>>();
        this.additionalIdentifiers.forEach(i -> identifiers.add(i.stream().map(Object::toString).collect(Collectors.toList())));
        return identifiers;
    }

    public List<String> getReadOnlyPropertiesAsStrings() throws ValidationException {
        return this.readOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getWriteOnlyPropertiesAsStrings() throws ValidationException {
        return this.writeOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public Map<String, Object> getUnprocessedProperties() {
        return Collections.unmodifiableMap(this.unprocessedProperties);
    }

    public void removeWriteOnlyProperties(JSONObject resourceModel) {
        this.getWriteOnlyPropertiesAsStrings().stream().forEach(writeOnlyProperty -> ResourceTypeSchema.removeProperty(new PublicJSONPointer(writeOnlyProperty.replaceFirst("^/properties", "")), resourceModel));
    }

    public static void removeProperty(PublicJSONPointer property, JSONObject resourceModel) {
        List<String> refTokens = property.getRefTokens();
        String key = refTokens.get(refTokens.size() - 1);
        try {
            if (refTokens.size() > 1) {
                JSONPointer parentObjectPointer = new JSONPointer(refTokens.subList(0, refTokens.size() - 1));
                JSONObject parentObject = (JSONObject)parentObjectPointer.queryFrom((Object)resourceModel);
                parentObject.remove(key);
            } else {
                resourceModel.remove(key);
            }
        }
        catch (NumberFormatException | JSONPointerException throwable) {
            // empty catch block
        }
    }

    public boolean definesProperty(String field) {
        return this.schema.definesProperty(field);
    }

    public void validate(JSONObject json) {
        this.getSchema().validate((Object)json);
    }

    @Generated
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    @Generated
    public List<JSONPointer> getCreateOnlyProperties() {
        return this.createOnlyProperties;
    }

    @Generated
    public List<JSONPointer> getDeprecatedProperties() {
        return this.deprecatedProperties;
    }

    @Generated
    public List<JSONPointer> getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    @Generated
    public List<List<JSONPointer>> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    @Generated
    public List<JSONPointer> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    @Generated
    public List<JSONPointer> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }
}

