/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;
import software.amazon.awssdk.services.xray.model.FaultStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeStatistics> {
    private static final SdkField<Long> OK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(EdgeStatistics.getter(EdgeStatistics::okCount)).setter(EdgeStatistics.setter(Builder::okCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkCount").build()}).build();
    private static final SdkField<ErrorStatistics> ERROR_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EdgeStatistics.getter(EdgeStatistics::errorStatistics)).setter(EdgeStatistics.setter(Builder::errorStatistics)).constructor(ErrorStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorStatistics").build()}).build();
    private static final SdkField<FaultStatistics> FAULT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EdgeStatistics.getter(EdgeStatistics::faultStatistics)).setter(EdgeStatistics.setter(Builder::faultStatistics)).constructor(FaultStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultStatistics").build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(EdgeStatistics.getter(EdgeStatistics::totalCount)).setter(EdgeStatistics.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<Double> TOTAL_RESPONSE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(EdgeStatistics.getter(EdgeStatistics::totalResponseTime)).setter(EdgeStatistics.setter(Builder::totalResponseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResponseTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OK_COUNT_FIELD, ERROR_STATISTICS_FIELD, FAULT_STATISTICS_FIELD, TOTAL_COUNT_FIELD, TOTAL_RESPONSE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long okCount;
    private final ErrorStatistics errorStatistics;
    private final FaultStatistics faultStatistics;
    private final Long totalCount;
    private final Double totalResponseTime;

    private EdgeStatistics(BuilderImpl builder) {
        this.okCount = builder.okCount;
        this.errorStatistics = builder.errorStatistics;
        this.faultStatistics = builder.faultStatistics;
        this.totalCount = builder.totalCount;
        this.totalResponseTime = builder.totalResponseTime;
    }

    public Long okCount() {
        return this.okCount;
    }

    public ErrorStatistics errorStatistics() {
        return this.errorStatistics;
    }

    public FaultStatistics faultStatistics() {
        return this.faultStatistics;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Double totalResponseTime() {
        return this.totalResponseTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.okCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResponseTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStatistics)) {
            return false;
        }
        EdgeStatistics other = (EdgeStatistics)obj;
        return Objects.equals(this.okCount(), other.okCount()) && Objects.equals(this.errorStatistics(), other.errorStatistics()) && Objects.equals(this.faultStatistics(), other.faultStatistics()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.totalResponseTime(), other.totalResponseTime());
    }

    public String toString() {
        return ToString.builder((String)"EdgeStatistics").add("OkCount", (Object)this.okCount()).add("ErrorStatistics", (Object)this.errorStatistics()).add("FaultStatistics", (Object)this.faultStatistics()).add("TotalCount", (Object)this.totalCount()).add("TotalResponseTime", (Object)this.totalResponseTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OkCount": {
                return Optional.ofNullable(clazz.cast(this.okCount()));
            }
            case "ErrorStatistics": {
                return Optional.ofNullable(clazz.cast(this.errorStatistics()));
            }
            case "FaultStatistics": {
                return Optional.ofNullable(clazz.cast(this.faultStatistics()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "TotalResponseTime": {
                return Optional.ofNullable(clazz.cast(this.totalResponseTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeStatistics, T> g) {
        return obj -> g.apply((EdgeStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long okCount;
        private ErrorStatistics errorStatistics;
        private FaultStatistics faultStatistics;
        private Long totalCount;
        private Double totalResponseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStatistics model) {
            this.okCount(model.okCount);
            this.errorStatistics(model.errorStatistics);
            this.faultStatistics(model.faultStatistics);
            this.totalCount(model.totalCount);
            this.totalResponseTime(model.totalResponseTime);
        }

        public final Long getOkCount() {
            return this.okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        public final ErrorStatistics.Builder getErrorStatistics() {
            return this.errorStatistics != null ? this.errorStatistics.toBuilder() : null;
        }

        @Override
        public final Builder errorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
            return this;
        }

        public final void setErrorStatistics(ErrorStatistics.BuilderImpl errorStatistics) {
            this.errorStatistics = errorStatistics != null ? errorStatistics.build() : null;
        }

        public final FaultStatistics.Builder getFaultStatistics() {
            return this.faultStatistics != null ? this.faultStatistics.toBuilder() : null;
        }

        @Override
        public final Builder faultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
            return this;
        }

        public final void setFaultStatistics(FaultStatistics.BuilderImpl faultStatistics) {
            this.faultStatistics = faultStatistics != null ? faultStatistics.build() : null;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public final Double getTotalResponseTime() {
            return this.totalResponseTime;
        }

        @Override
        public final Builder totalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
            return this;
        }

        public final void setTotalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
        }

        public EdgeStatistics build() {
            return new EdgeStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeStatistics> {
        public Builder okCount(Long var1);

        public Builder errorStatistics(ErrorStatistics var1);

        default public Builder errorStatistics(Consumer<ErrorStatistics.Builder> errorStatistics) {
            return this.errorStatistics((ErrorStatistics)((ErrorStatistics.Builder)ErrorStatistics.builder().applyMutation(errorStatistics)).build());
        }

        public Builder faultStatistics(FaultStatistics var1);

        default public Builder faultStatistics(Consumer<FaultStatistics.Builder> faultStatistics) {
            return this.faultStatistics((FaultStatistics)((FaultStatistics.Builder)FaultStatistics.builder().applyMutation(faultStatistics)).build());
        }

        public Builder totalCount(Long var1);

        public Builder totalResponseTime(Double var1);
    }
}

