/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetGroupsRequest;
import software.amazon.awssdk.services.xray.model.GetGroupsResponse;
import software.amazon.awssdk.services.xray.model.GroupSummary;

public class GetGroupsPublisher
implements SdkPublisher<GetGroupsResponse> {
    private final XRayAsyncClient client;
    private final GetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetGroupsPublisher(XRayAsyncClient client, GetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetGroupsPublisher(XRayAsyncClient client, GetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupSummary> groups() {
        Function<GetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetGroupsResponseFetcher
    implements AsyncPageFetcher<GetGroupsResponse> {
        private GetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetGroupsResponse> nextPage(GetGroupsResponse previousPage) {
            if (previousPage == null) {
                return GetGroupsPublisher.this.client.getGroups(GetGroupsPublisher.this.firstRequest);
            }
            return GetGroupsPublisher.this.client.getGroups((GetGroupsRequest)((Object)GetGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

