/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Group
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Group> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Group.getter(Group::groupName)).setter(Group.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Group.getter(Group::groupARN)).setter(Group.setter(Builder::groupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Group.getter(Group::filterExpression)).setter(Group.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_ARN_FIELD, FILTER_EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String groupARN;
    private final String filterExpression;

    private Group(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.filterExpression = builder.filterExpression;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupARN() {
        return this.groupARN;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupARN(), other.groupARN()) && Objects.equals(this.filterExpression(), other.filterExpression());
    }

    public String toString() {
        return ToString.builder((String)"Group").add("GroupName", (Object)this.groupName()).add("GroupARN", (Object)this.groupARN()).add("FilterExpression", (Object)this.filterExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupARN": {
                return Optional.ofNullable(clazz.cast(this.groupARN()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String groupARN;
        private String filterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            this.groupName(model.groupName);
            this.groupARN(model.groupARN);
            this.filterExpression(model.filterExpression);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupARN() {
            return this.groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public Group build() {
            return new Group(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Group> {
        public Builder groupName(String var1);

        public Builder groupARN(String var1);

        public Builder filterExpression(String var1);
    }
}

