/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Segment;
import software.amazon.awssdk.services.xray.model.SegmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trace> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trace.getter(Trace::id)).setter(Trace.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Trace.getter(Trace::duration)).setter(Trace.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<List<Segment>> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Trace.getter(Trace::segments)).setter(Trace.setter(Builder::segments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Segment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DURATION_FIELD, SEGMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Double duration;
    private final List<Segment> segments;

    private Trace(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.segments = builder.segments;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public List<Segment> segments() {
        return this.segments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.segments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.segments(), other.segments());
    }

    public String toString() {
        return ToString.builder((String)"Trace").add("Id", (Object)this.id()).add("Duration", (Object)this.duration()).add("Segments", this.segments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trace, T> g) {
        return obj -> g.apply((Trace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private List<Segment> segments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            this.id(model.id);
            this.duration(model.duration);
            this.segments(model.segments);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Collection<Segment.Builder> getSegments() {
            return this.segments != null ? (Collection)this.segments.stream().map(Segment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder segments(Collection<Segment> segments) {
            this.segments = SegmentListCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Segment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<Segment.Builder> ... segments) {
            this.segments(Stream.of(segments).map(c -> (Segment)((Segment.Builder)Segment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSegments(Collection<Segment.BuilderImpl> segments) {
            this.segments = SegmentListCopier.copyFromBuilder(segments);
        }

        public Trace build() {
            return new Trace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trace> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder segments(Collection<Segment> var1);

        public Builder segments(Segment ... var1);

        public Builder segments(Consumer<Segment.Builder> ... var1);
    }
}

