/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.TraceFormatType;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetrievedTracesRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, ListRetrievedTracesRequest> {
    private static final SdkField<String> RETRIEVAL_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalToken").getter(ListRetrievedTracesRequest.getter(ListRetrievedTracesRequest::retrievalToken)).setter(ListRetrievedTracesRequest.setter(Builder::retrievalToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalToken").build()}).build();
    private static final SdkField<String> TRACE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceFormat").getter(ListRetrievedTracesRequest.getter(ListRetrievedTracesRequest::traceFormatAsString)).setter(ListRetrievedTracesRequest.setter(Builder::traceFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceFormat").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRetrievedTracesRequest.getter(ListRetrievedTracesRequest::nextToken)).setter(ListRetrievedTracesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_TOKEN_FIELD, TRACE_FORMAT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRetrievedTracesRequest.memberNameToFieldInitializer();
    private final String retrievalToken;
    private final String traceFormat;
    private final String nextToken;

    private ListRetrievedTracesRequest(BuilderImpl builder) {
        super(builder);
        this.retrievalToken = builder.retrievalToken;
        this.traceFormat = builder.traceFormat;
        this.nextToken = builder.nextToken;
    }

    public final String retrievalToken() {
        return this.retrievalToken;
    }

    public final TraceFormatType traceFormat() {
        return TraceFormatType.fromValue(this.traceFormat);
    }

    public final String traceFormatAsString() {
        return this.traceFormat;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrievedTracesRequest)) {
            return false;
        }
        ListRetrievedTracesRequest other = (ListRetrievedTracesRequest)((Object)obj);
        return Objects.equals(this.retrievalToken(), other.retrievalToken()) && Objects.equals(this.traceFormatAsString(), other.traceFormatAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetrievedTracesRequest").add("RetrievalToken", (Object)this.retrievalToken()).add("TraceFormat", (Object)this.traceFormatAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetrievalToken": {
                return Optional.ofNullable(clazz.cast(this.retrievalToken()));
            }
            case "TraceFormat": {
                return Optional.ofNullable(clazz.cast(this.traceFormatAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RetrievalToken", RETRIEVAL_TOKEN_FIELD);
        map.put("TraceFormat", TRACE_FORMAT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrievedTracesRequest, T> g) {
        return obj -> g.apply((ListRetrievedTracesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private String retrievalToken;
        private String traceFormat;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrievedTracesRequest model) {
            super(model);
            this.retrievalToken(model.retrievalToken);
            this.traceFormat(model.traceFormat);
            this.nextToken(model.nextToken);
        }

        public final String getRetrievalToken() {
            return this.retrievalToken;
        }

        public final void setRetrievalToken(String retrievalToken) {
            this.retrievalToken = retrievalToken;
        }

        @Override
        public final Builder retrievalToken(String retrievalToken) {
            this.retrievalToken = retrievalToken;
            return this;
        }

        public final String getTraceFormat() {
            return this.traceFormat;
        }

        public final void setTraceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
        }

        @Override
        public final Builder traceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
            return this;
        }

        @Override
        public final Builder traceFormat(TraceFormatType traceFormat) {
            this.traceFormat(traceFormat == null ? null : traceFormat.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRetrievedTracesRequest build() {
            return new ListRetrievedTracesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetrievedTracesRequest> {
        public Builder retrievalToken(String var1);

        public Builder traceFormat(String var1);

        public Builder traceFormat(TraceFormatType var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

