/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Http
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Http> {
    private static final SdkField<String> HTTP_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpURL").getter(Http.getter(Http::httpURL)).setter(Http.setter(Builder::httpURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpURL").build()}).build();
    private static final SdkField<Integer> HTTP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpStatus").getter(Http.getter(Http::httpStatus)).setter(Http.setter(Builder::httpStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpStatus").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpMethod").getter(Http.getter(Http::httpMethod)).setter(Http.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserAgent").getter(Http.getter(Http::userAgent)).setter(Http.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAgent").build()}).build();
    private static final SdkField<String> CLIENT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientIp").getter(Http.getter(Http::clientIp)).setter(Http.setter(Builder::clientIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_URL_FIELD, HTTP_STATUS_FIELD, HTTP_METHOD_FIELD, USER_AGENT_FIELD, CLIENT_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Http.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpURL;
    private final Integer httpStatus;
    private final String httpMethod;
    private final String userAgent;
    private final String clientIp;

    private Http(BuilderImpl builder) {
        this.httpURL = builder.httpURL;
        this.httpStatus = builder.httpStatus;
        this.httpMethod = builder.httpMethod;
        this.userAgent = builder.userAgent;
        this.clientIp = builder.clientIp;
    }

    public final String httpURL() {
        return this.httpURL;
    }

    public final Integer httpStatus() {
        return this.httpStatus;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public final String clientIp() {
        return this.clientIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http)obj;
        return Objects.equals(this.httpURL(), other.httpURL()) && Objects.equals(this.httpStatus(), other.httpStatus()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.clientIp(), other.clientIp());
    }

    public final String toString() {
        return ToString.builder((String)"Http").add("HttpURL", (Object)this.httpURL()).add("HttpStatus", (Object)this.httpStatus()).add("HttpMethod", (Object)this.httpMethod()).add("UserAgent", (Object)this.userAgent()).add("ClientIp", (Object)this.clientIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpURL": {
                return Optional.ofNullable(clazz.cast(this.httpURL()));
            }
            case "HttpStatus": {
                return Optional.ofNullable(clazz.cast(this.httpStatus()));
            }
            case "HttpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "UserAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
            case "ClientIp": {
                return Optional.ofNullable(clazz.cast(this.clientIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HttpURL", HTTP_URL_FIELD);
        map.put("HttpStatus", HTTP_STATUS_FIELD);
        map.put("HttpMethod", HTTP_METHOD_FIELD);
        map.put("UserAgent", USER_AGENT_FIELD);
        map.put("ClientIp", CLIENT_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Http, T> g) {
        return obj -> g.apply((Http)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpURL;
        private Integer httpStatus;
        private String httpMethod;
        private String userAgent;
        private String clientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Http model) {
            this.httpURL(model.httpURL);
            this.httpStatus(model.httpStatus);
            this.httpMethod(model.httpMethod);
            this.userAgent(model.userAgent);
            this.clientIp(model.clientIp);
        }

        public final String getHttpURL() {
            return this.httpURL;
        }

        public final void setHttpURL(String httpURL) {
            this.httpURL = httpURL;
        }

        @Override
        public final Builder httpURL(String httpURL) {
            this.httpURL = httpURL;
            return this;
        }

        public final Integer getHttpStatus() {
            return this.httpStatus;
        }

        public final void setHttpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
        }

        @Override
        public final Builder httpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final String getClientIp() {
            return this.clientIp;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        @Override
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public Http build() {
            return new Http(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Http> {
        public Builder httpURL(String var1);

        public Builder httpStatus(Integer var1);

        public Builder httpMethod(String var1);

        public Builder userAgent(String var1);

        public Builder clientIp(String var1);
    }
}

