/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.TraceSummary;

public class GetTraceSummariesPublisher
implements SdkPublisher<GetTraceSummariesResponse> {
    private final XRayAsyncClient client;
    private final GetTraceSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTraceSummariesPublisher(XRayAsyncClient client, GetTraceSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTraceSummariesPublisher(XRayAsyncClient client, GetTraceSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTraceSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTraceSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TraceSummary> traceSummaries() {
        Function<GetTraceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.traceSummaries() != null) {
                return response.traceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTraceSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetTraceSummariesPublisher resume(GetTraceSummariesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetTraceSummariesPublisher(this.client, (GetTraceSummariesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetTraceSummariesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetTraceSummariesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetTraceSummariesResponseFetcher
    implements AsyncPageFetcher<GetTraceSummariesResponse> {
        private GetTraceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetTraceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTraceSummariesResponse> nextPage(GetTraceSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetTraceSummariesPublisher.this.client.getTraceSummaries(GetTraceSummariesPublisher.this.firstRequest);
            }
            return GetTraceSummariesPublisher.this.client.getTraceSummaries((GetTraceSummariesRequest)((Object)GetTraceSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

