/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.IndexingRuleValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexingRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(IndexingRule.getter(IndexingRule::name)).setter(IndexingRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(IndexingRule.getter(IndexingRule::modifiedAt)).setter(IndexingRule.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<IndexingRuleValue> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(IndexingRule.getter(IndexingRule::rule)).setter(IndexingRule.setter(Builder::rule)).constructor(IndexingRuleValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MODIFIED_AT_FIELD, RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("ModifiedAt", MODIFIED_AT_FIELD);
            this.put("Rule", RULE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant modifiedAt;
    private final IndexingRuleValue rule;

    private IndexingRule(BuilderImpl builder) {
        this.name = builder.name;
        this.modifiedAt = builder.modifiedAt;
        this.rule = builder.rule;
    }

    public final String name() {
        return this.name;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final IndexingRuleValue rule() {
        return this.rule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexingRule)) {
            return false;
        }
        IndexingRule other = (IndexingRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.rule(), other.rule());
    }

    public final String toString() {
        return ToString.builder((String)"IndexingRule").add("Name", (Object)this.name()).add("ModifiedAt", (Object)this.modifiedAt()).add("Rule", (Object)this.rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IndexingRule, T> g) {
        return obj -> g.apply((IndexingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant modifiedAt;
        private IndexingRuleValue rule;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexingRule model) {
            this.name(model.name);
            this.modifiedAt(model.modifiedAt);
            this.rule(model.rule);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final IndexingRuleValue.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(IndexingRuleValue.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(IndexingRuleValue rule) {
            this.rule = rule;
            return this;
        }

        public IndexingRule build() {
            return new IndexingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexingRule> {
        public Builder name(String var1);

        public Builder modifiedAt(Instant var1);

        public Builder rule(IndexingRuleValue var1);

        default public Builder rule(Consumer<IndexingRuleValue.Builder> rule) {
            return this.rule((IndexingRuleValue)((IndexingRuleValue.Builder)IndexingRuleValue.builder().applyMutation(rule)).build());
        }
    }
}

