/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TraceSummary;
import software.amazon.awssdk.services.xray.model.TraceSummaryListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTraceSummariesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetTraceSummariesResponse> {
    private static final SdkField<List<TraceSummary>> TRACE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TraceSummaries").getter(GetTraceSummariesResponse.getter(GetTraceSummariesResponse::traceSummaries)).setter(GetTraceSummariesResponse.setter(Builder::traceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TraceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> APPROXIMATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApproximateTime").getter(GetTraceSummariesResponse.getter(GetTraceSummariesResponse::approximateTime)).setter(GetTraceSummariesResponse.setter(Builder::approximateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTime").build()}).build();
    private static final SdkField<Long> TRACES_PROCESSED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TracesProcessedCount").getter(GetTraceSummariesResponse.getter(GetTraceSummariesResponse::tracesProcessedCount)).setter(GetTraceSummariesResponse.setter(Builder::tracesProcessedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracesProcessedCount").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTraceSummariesResponse.getter(GetTraceSummariesResponse::nextToken)).setter(GetTraceSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_SUMMARIES_FIELD, APPROXIMATE_TIME_FIELD, TRACES_PROCESSED_COUNT_FIELD, NEXT_TOKEN_FIELD));
    private final List<TraceSummary> traceSummaries;
    private final Instant approximateTime;
    private final Long tracesProcessedCount;
    private final String nextToken;

    private GetTraceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.traceSummaries = builder.traceSummaries;
        this.approximateTime = builder.approximateTime;
        this.tracesProcessedCount = builder.tracesProcessedCount;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTraceSummaries() {
        return this.traceSummaries != null && !(this.traceSummaries instanceof SdkAutoConstructList);
    }

    public final List<TraceSummary> traceSummaries() {
        return this.traceSummaries;
    }

    public final Instant approximateTime() {
        return this.approximateTime;
    }

    public final Long tracesProcessedCount() {
        return this.tracesProcessedCount;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraceSummaries() ? this.traceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracesProcessedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesResponse)) {
            return false;
        }
        GetTraceSummariesResponse other = (GetTraceSummariesResponse)((Object)obj);
        return this.hasTraceSummaries() == other.hasTraceSummaries() && Objects.equals(this.traceSummaries(), other.traceSummaries()) && Objects.equals(this.approximateTime(), other.approximateTime()) && Objects.equals(this.tracesProcessedCount(), other.tracesProcessedCount()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTraceSummariesResponse").add("TraceSummaries", this.hasTraceSummaries() ? this.traceSummaries() : null).add("ApproximateTime", (Object)this.approximateTime()).add("TracesProcessedCount", (Object)this.tracesProcessedCount()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TraceSummaries": {
                return Optional.ofNullable(clazz.cast(this.traceSummaries()));
            }
            case "ApproximateTime": {
                return Optional.ofNullable(clazz.cast(this.approximateTime()));
            }
            case "TracesProcessedCount": {
                return Optional.ofNullable(clazz.cast(this.tracesProcessedCount()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTraceSummariesResponse, T> g) {
        return obj -> g.apply((GetTraceSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<TraceSummary> traceSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant approximateTime;
        private Long tracesProcessedCount;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesResponse model) {
            super(model);
            this.traceSummaries(model.traceSummaries);
            this.approximateTime(model.approximateTime);
            this.tracesProcessedCount(model.tracesProcessedCount);
            this.nextToken(model.nextToken);
        }

        public final List<TraceSummary.Builder> getTraceSummaries() {
            List<TraceSummary.Builder> result = TraceSummaryListCopier.copyToBuilder(this.traceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraceSummaries(Collection<TraceSummary.BuilderImpl> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copyFromBuilder(traceSummaries);
        }

        @Override
        @Transient
        public final Builder traceSummaries(Collection<TraceSummary> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copy(traceSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traceSummaries(TraceSummary ... traceSummaries) {
            this.traceSummaries(Arrays.asList(traceSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traceSummaries(Consumer<TraceSummary.Builder> ... traceSummaries) {
            this.traceSummaries(Stream.of(traceSummaries).map(c -> (TraceSummary)((TraceSummary.Builder)TraceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getApproximateTime() {
            return this.approximateTime;
        }

        public final void setApproximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
        }

        @Override
        @Transient
        public final Builder approximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
            return this;
        }

        public final Long getTracesProcessedCount() {
            return this.tracesProcessedCount;
        }

        public final void setTracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
        }

        @Override
        @Transient
        public final Builder tracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTraceSummariesResponse build() {
            return new GetTraceSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTraceSummariesResponse> {
        public Builder traceSummaries(Collection<TraceSummary> var1);

        public Builder traceSummaries(TraceSummary ... var1);

        public Builder traceSummaries(Consumer<TraceSummary.Builder> ... var1);

        public Builder approximateTime(Instant var1);

        public Builder tracesProcessedCount(Long var1);

        public Builder nextToken(String var1);
    }
}

