/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.SamplingRuleRecord;
import software.amazon.awssdk.services.xray.model.SamplingRuleRecordListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamplingRulesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetSamplingRulesResponse> {
    private static final SdkField<List<SamplingRuleRecord>> SAMPLING_RULE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SamplingRuleRecords").getter(GetSamplingRulesResponse.getter(GetSamplingRulesResponse::samplingRuleRecords)).setter(GetSamplingRulesResponse.setter(Builder::samplingRuleRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRuleRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SamplingRuleRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSamplingRulesResponse.getter(GetSamplingRulesResponse::nextToken)).setter(GetSamplingRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_RULE_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SamplingRuleRecord> samplingRuleRecords;
    private final String nextToken;

    private GetSamplingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.samplingRuleRecords = builder.samplingRuleRecords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSamplingRuleRecords() {
        return this.samplingRuleRecords != null && !(this.samplingRuleRecords instanceof SdkAutoConstructList);
    }

    public final List<SamplingRuleRecord> samplingRuleRecords() {
        return this.samplingRuleRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamplingRuleRecords() ? this.samplingRuleRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingRulesResponse)) {
            return false;
        }
        GetSamplingRulesResponse other = (GetSamplingRulesResponse)((Object)obj);
        return this.hasSamplingRuleRecords() == other.hasSamplingRuleRecords() && Objects.equals(this.samplingRuleRecords(), other.samplingRuleRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSamplingRulesResponse").add("SamplingRuleRecords", this.hasSamplingRuleRecords() ? this.samplingRuleRecords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingRuleRecords": {
                return Optional.ofNullable(clazz.cast(this.samplingRuleRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingRulesResponse, T> g) {
        return obj -> g.apply((GetSamplingRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<SamplingRuleRecord> samplingRuleRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingRulesResponse model) {
            super(model);
            this.samplingRuleRecords(model.samplingRuleRecords);
            this.nextToken(model.nextToken);
        }

        public final List<SamplingRuleRecord.Builder> getSamplingRuleRecords() {
            List<SamplingRuleRecord.Builder> result = SamplingRuleRecordListCopier.copyToBuilder(this.samplingRuleRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamplingRuleRecords(Collection<SamplingRuleRecord.BuilderImpl> samplingRuleRecords) {
            this.samplingRuleRecords = SamplingRuleRecordListCopier.copyFromBuilder(samplingRuleRecords);
        }

        @Override
        @Transient
        public final Builder samplingRuleRecords(Collection<SamplingRuleRecord> samplingRuleRecords) {
            this.samplingRuleRecords = SamplingRuleRecordListCopier.copy(samplingRuleRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder samplingRuleRecords(SamplingRuleRecord ... samplingRuleRecords) {
            this.samplingRuleRecords(Arrays.asList(samplingRuleRecords));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder samplingRuleRecords(Consumer<SamplingRuleRecord.Builder> ... samplingRuleRecords) {
            this.samplingRuleRecords(Stream.of(samplingRuleRecords).map(c -> (SamplingRuleRecord)((SamplingRuleRecord.Builder)SamplingRuleRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSamplingRulesResponse build() {
            return new GetSamplingRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSamplingRulesResponse> {
        public Builder samplingRuleRecords(Collection<SamplingRuleRecord> var1);

        public Builder samplingRuleRecords(SamplingRuleRecord ... var1);

        public Builder samplingRuleRecords(Consumer<SamplingRuleRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

