/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.RootCauseException;
import software.amazon.awssdk.services.xray.model.RootCauseExceptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaultRootCauseEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaultRootCauseEntity> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FaultRootCauseEntity.getter(FaultRootCauseEntity::name)).setter(FaultRootCauseEntity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<RootCauseException>> EXCEPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exceptions").getter(FaultRootCauseEntity.getter(FaultRootCauseEntity::exceptions)).setter(FaultRootCauseEntity.setter(Builder::exceptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exceptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RootCauseException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REMOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Remote").getter(FaultRootCauseEntity.getter(FaultRootCauseEntity::remote)).setter(FaultRootCauseEntity.setter(Builder::remote)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remote").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXCEPTIONS_FIELD, REMOTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<RootCauseException> exceptions;
    private final Boolean remote;

    private FaultRootCauseEntity(BuilderImpl builder) {
        this.name = builder.name;
        this.exceptions = builder.exceptions;
        this.remote = builder.remote;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasExceptions() {
        return this.exceptions != null && !(this.exceptions instanceof SdkAutoConstructList);
    }

    public final List<RootCauseException> exceptions() {
        return this.exceptions;
    }

    public final Boolean remote() {
        return this.remote;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExceptions() ? this.exceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.remote());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaultRootCauseEntity)) {
            return false;
        }
        FaultRootCauseEntity other = (FaultRootCauseEntity)obj;
        return Objects.equals(this.name(), other.name()) && this.hasExceptions() == other.hasExceptions() && Objects.equals(this.exceptions(), other.exceptions()) && Objects.equals(this.remote(), other.remote());
    }

    public final String toString() {
        return ToString.builder((String)"FaultRootCauseEntity").add("Name", (Object)this.name()).add("Exceptions", this.hasExceptions() ? this.exceptions() : null).add("Remote", (Object)this.remote()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Exceptions": {
                return Optional.ofNullable(clazz.cast(this.exceptions()));
            }
            case "Remote": {
                return Optional.ofNullable(clazz.cast(this.remote()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaultRootCauseEntity, T> g) {
        return obj -> g.apply((FaultRootCauseEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<RootCauseException> exceptions = DefaultSdkAutoConstructList.getInstance();
        private Boolean remote;

        private BuilderImpl() {
        }

        private BuilderImpl(FaultRootCauseEntity model) {
            this.name(model.name);
            this.exceptions(model.exceptions);
            this.remote(model.remote);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<RootCauseException.Builder> getExceptions() {
            List<RootCauseException.Builder> result = RootCauseExceptionsCopier.copyToBuilder(this.exceptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder exceptions(Collection<RootCauseException> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copy(exceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(RootCauseException ... exceptions) {
            this.exceptions(Arrays.asList(exceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(Consumer<RootCauseException.Builder> ... exceptions) {
            this.exceptions(Stream.of(exceptions).map(c -> (RootCauseException)((RootCauseException.Builder)RootCauseException.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExceptions(Collection<RootCauseException.BuilderImpl> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copyFromBuilder(exceptions);
        }

        public final Boolean getRemote() {
            return this.remote;
        }

        @Override
        public final Builder remote(Boolean remote) {
            this.remote = remote;
            return this;
        }

        public final void setRemote(Boolean remote) {
            this.remote = remote;
        }

        public FaultRootCauseEntity build() {
            return new FaultRootCauseEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaultRootCauseEntity> {
        public Builder name(String var1);

        public Builder exceptions(Collection<RootCauseException> var1);

        public Builder exceptions(RootCauseException ... var1);

        public Builder exceptions(Consumer<RootCauseException.Builder> ... var1);

        public Builder remote(Boolean var1);
    }
}

