/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse;
import software.amazon.awssdk.services.xray.model.SamplingRuleRecord;

public class GetSamplingRulesPublisher
implements SdkPublisher<GetSamplingRulesResponse> {
    private final XRayAsyncClient client;
    private final GetSamplingRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSamplingRulesPublisher(XRayAsyncClient client, GetSamplingRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSamplingRulesPublisher(XRayAsyncClient client, GetSamplingRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSamplingRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSamplingRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SamplingRuleRecord> samplingRuleRecords() {
        Function<GetSamplingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samplingRuleRecords() != null) {
                return response.samplingRuleRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSamplingRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSamplingRulesResponseFetcher
    implements AsyncPageFetcher<GetSamplingRulesResponse> {
        private GetSamplingRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetSamplingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSamplingRulesResponse> nextPage(GetSamplingRulesResponse previousPage) {
            if (previousPage == null) {
                return GetSamplingRulesPublisher.this.client.getSamplingRules(GetSamplingRulesPublisher.this.firstRequest);
            }
            return GetSamplingRulesPublisher.this.client.getSamplingRules((GetSamplingRulesRequest)((Object)GetSamplingRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

