/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.InsightImpactGraphService;
import software.amazon.awssdk.services.xray.model.InsightImpactGraphServiceListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightImpactGraphResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetInsightImpactGraphResponse> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::insightId)).setter(GetInsightImpactGraphResponse.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::startTime)).setter(GetInsightImpactGraphResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::endTime)).setter(GetInsightImpactGraphResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> SERVICE_GRAPH_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceGraphStartTime").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::serviceGraphStartTime)).setter(GetInsightImpactGraphResponse.setter(Builder::serviceGraphStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceGraphStartTime").build()}).build();
    private static final SdkField<Instant> SERVICE_GRAPH_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceGraphEndTime").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::serviceGraphEndTime)).setter(GetInsightImpactGraphResponse.setter(Builder::serviceGraphEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceGraphEndTime").build()}).build();
    private static final SdkField<List<InsightImpactGraphService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::services)).setter(GetInsightImpactGraphResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightImpactGraphService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInsightImpactGraphResponse.getter(GetInsightImpactGraphResponse::nextToken)).setter(GetInsightImpactGraphResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, SERVICE_GRAPH_START_TIME_FIELD, SERVICE_GRAPH_END_TIME_FIELD, SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private final String insightId;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant serviceGraphStartTime;
    private final Instant serviceGraphEndTime;
    private final List<InsightImpactGraphService> services;
    private final String nextToken;

    private GetInsightImpactGraphResponse(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceGraphStartTime = builder.serviceGraphStartTime;
        this.serviceGraphEndTime = builder.serviceGraphEndTime;
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public final String insightId() {
        return this.insightId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant serviceGraphStartTime() {
        return this.serviceGraphStartTime;
    }

    public final Instant serviceGraphEndTime() {
        return this.serviceGraphEndTime;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<InsightImpactGraphService> services() {
        return this.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceGraphStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceGraphEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightImpactGraphResponse)) {
            return false;
        }
        GetInsightImpactGraphResponse other = (GetInsightImpactGraphResponse)((Object)obj);
        return Objects.equals(this.insightId(), other.insightId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.serviceGraphStartTime(), other.serviceGraphStartTime()) && Objects.equals(this.serviceGraphEndTime(), other.serviceGraphEndTime()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInsightImpactGraphResponse").add("InsightId", (Object)this.insightId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ServiceGraphStartTime", (Object)this.serviceGraphStartTime()).add("ServiceGraphEndTime", (Object)this.serviceGraphEndTime()).add("Services", this.hasServices() ? this.services() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ServiceGraphStartTime": {
                return Optional.ofNullable(clazz.cast(this.serviceGraphStartTime()));
            }
            case "ServiceGraphEndTime": {
                return Optional.ofNullable(clazz.cast(this.serviceGraphEndTime()));
            }
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightImpactGraphResponse, T> g) {
        return obj -> g.apply((GetInsightImpactGraphResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private String insightId;
        private Instant startTime;
        private Instant endTime;
        private Instant serviceGraphStartTime;
        private Instant serviceGraphEndTime;
        private List<InsightImpactGraphService> services = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightImpactGraphResponse model) {
            super(model);
            this.insightId(model.insightId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.serviceGraphStartTime(model.serviceGraphStartTime);
            this.serviceGraphEndTime(model.serviceGraphEndTime);
            this.services(model.services);
            this.nextToken(model.nextToken);
        }

        public final String getInsightId() {
            return this.insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getServiceGraphStartTime() {
            return this.serviceGraphStartTime;
        }

        @Override
        public final Builder serviceGraphStartTime(Instant serviceGraphStartTime) {
            this.serviceGraphStartTime = serviceGraphStartTime;
            return this;
        }

        public final void setServiceGraphStartTime(Instant serviceGraphStartTime) {
            this.serviceGraphStartTime = serviceGraphStartTime;
        }

        public final Instant getServiceGraphEndTime() {
            return this.serviceGraphEndTime;
        }

        @Override
        public final Builder serviceGraphEndTime(Instant serviceGraphEndTime) {
            this.serviceGraphEndTime = serviceGraphEndTime;
            return this;
        }

        public final void setServiceGraphEndTime(Instant serviceGraphEndTime) {
            this.serviceGraphEndTime = serviceGraphEndTime;
        }

        public final Collection<InsightImpactGraphService.Builder> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services != null ? (Collection)this.services.stream().map(InsightImpactGraphService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<InsightImpactGraphService> services) {
            this.services = InsightImpactGraphServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(InsightImpactGraphService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<InsightImpactGraphService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (InsightImpactGraphService)((InsightImpactGraphService.Builder)InsightImpactGraphService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<InsightImpactGraphService.BuilderImpl> services) {
            this.services = InsightImpactGraphServiceListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInsightImpactGraphResponse build() {
            return new GetInsightImpactGraphResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightImpactGraphResponse> {
        public Builder insightId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder serviceGraphStartTime(Instant var1);

        public Builder serviceGraphEndTime(Instant var1);

        public Builder services(Collection<InsightImpactGraphService> var1);

        public Builder services(InsightImpactGraphService ... var1);

        public Builder services(Consumer<InsightImpactGraphService.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

