/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTelemetryRecordsRequest extends XRayRequest implements
        ToCopyableBuilder<PutTelemetryRecordsRequest.Builder, PutTelemetryRecordsRequest> {
    private static final SdkField<List<TelemetryRecord>> TELEMETRY_RECORDS_FIELD = SdkField
            .<List<TelemetryRecord>> builder(MarshallingType.LIST)
            .memberName("TelemetryRecords")
            .getter(getter(PutTelemetryRecordsRequest::telemetryRecords))
            .setter(setter(Builder::telemetryRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TelemetryRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(TelemetryRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceId").getter(getter(PutTelemetryRecordsRequest::ec2InstanceId))
            .setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceId").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(PutTelemetryRecordsRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(PutTelemetryRecordsRequest::resourceARN))
            .setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_RECORDS_FIELD,
            EC2_INSTANCE_ID_FIELD, HOSTNAME_FIELD, RESOURCE_ARN_FIELD));

    private final List<TelemetryRecord> telemetryRecords;

    private final String ec2InstanceId;

    private final String hostname;

    private final String resourceARN;

    private PutTelemetryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.telemetryRecords = builder.telemetryRecords;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.hostname = builder.hostname;
        this.resourceARN = builder.resourceARN;
    }

    /**
     * Returns true if the TelemetryRecords property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTelemetryRecords() {
        return telemetryRecords != null && !(telemetryRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTelemetryRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<TelemetryRecord> telemetryRecords() {
        return telemetryRecords;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String resourceARN() {
        return resourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTelemetryRecords() ? telemetryRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest) obj;
        return hasTelemetryRecords() == other.hasTelemetryRecords()
                && Objects.equals(telemetryRecords(), other.telemetryRecords())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(resourceARN(), other.resourceARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTelemetryRecordsRequest")
                .add("TelemetryRecords", hasTelemetryRecords() ? telemetryRecords() : null).add("EC2InstanceId", ec2InstanceId())
                .add("Hostname", hostname()).add("ResourceARN", resourceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelemetryRecords":
            return Optional.ofNullable(clazz.cast(telemetryRecords()));
        case "EC2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTelemetryRecordsRequest, T> g) {
        return obj -> g.apply((PutTelemetryRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutTelemetryRecordsRequest> {
        /**
         * <p/>
         * 
         * @param telemetryRecords
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords);

        /**
         * <p/>
         * 
         * @param telemetryRecords
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryRecords(TelemetryRecord... telemetryRecords);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<TelemetryRecord>.Builder} avoiding the need
         * to create one manually via {@link List<TelemetryRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TelemetryRecord>.Builder#build()} is called immediately and
         * its result is passed to {@link #telemetryRecords(List<TelemetryRecord>)}.
         * 
         * @param telemetryRecords
         *        a consumer that will call methods on {@link List<TelemetryRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryRecords(List<TelemetryRecord>)
         */
        Builder telemetryRecords(Consumer<TelemetryRecord.Builder>... telemetryRecords);

        /**
         * <p/>
         * 
         * @param ec2InstanceId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p/>
         * 
         * @param hostname
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p/>
         * 
         * @param resourceARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private List<TelemetryRecord> telemetryRecords = DefaultSdkAutoConstructList.getInstance();

        private String ec2InstanceId;

        private String hostname;

        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTelemetryRecordsRequest model) {
            super(model);
            telemetryRecords(model.telemetryRecords);
            ec2InstanceId(model.ec2InstanceId);
            hostname(model.hostname);
            resourceARN(model.resourceARN);
        }

        public final Collection<TelemetryRecord.Builder> getTelemetryRecords() {
            if (telemetryRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return telemetryRecords != null ? telemetryRecords.stream().map(TelemetryRecord::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(TelemetryRecord... telemetryRecords) {
            telemetryRecords(Arrays.asList(telemetryRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(Consumer<TelemetryRecord.Builder>... telemetryRecords) {
            telemetryRecords(Stream.of(telemetryRecords).map(c -> TelemetryRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryRecords(Collection<TelemetryRecord.BuilderImpl> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copyFromBuilder(telemetryRecords);
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTelemetryRecordsRequest build() {
            return new PutTelemetryRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
