/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.AnomalousService;
import software.amazon.awssdk.services.xray.model.AnomalousServiceListCopier;
import software.amazon.awssdk.services.xray.model.InsightCategory;
import software.amazon.awssdk.services.xray.model.InsightCategoryListCopier;
import software.amazon.awssdk.services.xray.model.InsightState;
import software.amazon.awssdk.services.xray.model.RequestImpactStatistics;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightSummary> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(InsightSummary.getter(InsightSummary::insightId)).setter(InsightSummary.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupARN").getter(InsightSummary.getter(InsightSummary::groupARN)).setter(InsightSummary.setter(Builder::groupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(InsightSummary.getter(InsightSummary::groupName)).setter(InsightSummary.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<ServiceId> ROOT_CAUSE_SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootCauseServiceId").getter(InsightSummary.getter(InsightSummary::rootCauseServiceId)).setter(InsightSummary.setter(Builder::rootCauseServiceId)).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCauseServiceId").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(InsightSummary.getter(InsightSummary::categoriesAsStrings)).setter(InsightSummary.setter(Builder::categoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(InsightSummary.getter(InsightSummary::stateAsString)).setter(InsightSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(InsightSummary.getter(InsightSummary::startTime)).setter(InsightSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(InsightSummary.getter(InsightSummary::endTime)).setter(InsightSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Summary").getter(InsightSummary.getter(InsightSummary::summary)).setter(InsightSummary.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<RequestImpactStatistics> CLIENT_REQUEST_IMPACT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientRequestImpactStatistics").getter(InsightSummary.getter(InsightSummary::clientRequestImpactStatistics)).setter(InsightSummary.setter(Builder::clientRequestImpactStatistics)).constructor(RequestImpactStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestImpactStatistics").build()}).build();
    private static final SdkField<RequestImpactStatistics> ROOT_CAUSE_SERVICE_REQUEST_IMPACT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootCauseServiceRequestImpactStatistics").getter(InsightSummary.getter(InsightSummary::rootCauseServiceRequestImpactStatistics)).setter(InsightSummary.setter(Builder::rootCauseServiceRequestImpactStatistics)).constructor(RequestImpactStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCauseServiceRequestImpactStatistics").build()}).build();
    private static final SdkField<List<AnomalousService>> TOP_ANOMALOUS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopAnomalousServices").getter(InsightSummary.getter(InsightSummary::topAnomalousServices)).setter(InsightSummary.setter(Builder::topAnomalousServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnomalousServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalousService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(InsightSummary.getter(InsightSummary::lastUpdateTime)).setter(InsightSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD, GROUP_ARN_FIELD, GROUP_NAME_FIELD, ROOT_CAUSE_SERVICE_ID_FIELD, CATEGORIES_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD, SUMMARY_FIELD, CLIENT_REQUEST_IMPACT_STATISTICS_FIELD, ROOT_CAUSE_SERVICE_REQUEST_IMPACT_STATISTICS_FIELD, TOP_ANOMALOUS_SERVICES_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String insightId;
    private final String groupARN;
    private final String groupName;
    private final ServiceId rootCauseServiceId;
    private final List<String> categories;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;
    private final String summary;
    private final RequestImpactStatistics clientRequestImpactStatistics;
    private final RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
    private final List<AnomalousService> topAnomalousServices;
    private final Instant lastUpdateTime;

    private InsightSummary(BuilderImpl builder) {
        this.insightId = builder.insightId;
        this.groupARN = builder.groupARN;
        this.groupName = builder.groupName;
        this.rootCauseServiceId = builder.rootCauseServiceId;
        this.categories = builder.categories;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summary = builder.summary;
        this.clientRequestImpactStatistics = builder.clientRequestImpactStatistics;
        this.rootCauseServiceRequestImpactStatistics = builder.rootCauseServiceRequestImpactStatistics;
        this.topAnomalousServices = builder.topAnomalousServices;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String insightId() {
        return this.insightId;
    }

    public String groupARN() {
        return this.groupARN;
    }

    public String groupName() {
        return this.groupName;
    }

    public ServiceId rootCauseServiceId() {
        return this.rootCauseServiceId;
    }

    public List<InsightCategory> categories() {
        return InsightCategoryListCopier.copyStringToEnum(this.categories);
    }

    public boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public List<String> categoriesAsStrings() {
        return this.categories;
    }

    public InsightState state() {
        return InsightState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String summary() {
        return this.summary;
    }

    public RequestImpactStatistics clientRequestImpactStatistics() {
        return this.clientRequestImpactStatistics;
    }

    public RequestImpactStatistics rootCauseServiceRequestImpactStatistics() {
        return this.rootCauseServiceRequestImpactStatistics;
    }

    public boolean hasTopAnomalousServices() {
        return this.topAnomalousServices != null && !(this.topAnomalousServices instanceof SdkAutoConstructList);
    }

    public List<AnomalousService> topAnomalousServices() {
        return this.topAnomalousServices;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootCauseServiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestImpactStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootCauseServiceRequestImpactStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopAnomalousServices() ? this.topAnomalousServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightSummary)) {
            return false;
        }
        InsightSummary other = (InsightSummary)obj;
        return Objects.equals(this.insightId(), other.insightId()) && Objects.equals(this.groupARN(), other.groupARN()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.rootCauseServiceId(), other.rootCauseServiceId()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categoriesAsStrings(), other.categoriesAsStrings()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.clientRequestImpactStatistics(), other.clientRequestImpactStatistics()) && Objects.equals(this.rootCauseServiceRequestImpactStatistics(), other.rootCauseServiceRequestImpactStatistics()) && this.hasTopAnomalousServices() == other.hasTopAnomalousServices() && Objects.equals(this.topAnomalousServices(), other.topAnomalousServices()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"InsightSummary").add("InsightId", (Object)this.insightId()).add("GroupARN", (Object)this.groupARN()).add("GroupName", (Object)this.groupName()).add("RootCauseServiceId", (Object)this.rootCauseServiceId()).add("Categories", this.hasCategories() ? this.categoriesAsStrings() : null).add("State", (Object)this.stateAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Summary", (Object)this.summary()).add("ClientRequestImpactStatistics", (Object)this.clientRequestImpactStatistics()).add("RootCauseServiceRequestImpactStatistics", (Object)this.rootCauseServiceRequestImpactStatistics()).add("TopAnomalousServices", this.hasTopAnomalousServices() ? this.topAnomalousServices() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "GroupARN": {
                return Optional.ofNullable(clazz.cast(this.groupARN()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "RootCauseServiceId": {
                return Optional.ofNullable(clazz.cast(this.rootCauseServiceId()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categoriesAsStrings()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "ClientRequestImpactStatistics": {
                return Optional.ofNullable(clazz.cast(this.clientRequestImpactStatistics()));
            }
            case "RootCauseServiceRequestImpactStatistics": {
                return Optional.ofNullable(clazz.cast(this.rootCauseServiceRequestImpactStatistics()));
            }
            case "TopAnomalousServices": {
                return Optional.ofNullable(clazz.cast(this.topAnomalousServices()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightSummary, T> g) {
        return obj -> g.apply((InsightSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightId;
        private String groupARN;
        private String groupName;
        private ServiceId rootCauseServiceId;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Instant startTime;
        private Instant endTime;
        private String summary;
        private RequestImpactStatistics clientRequestImpactStatistics;
        private RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
        private List<AnomalousService> topAnomalousServices = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightSummary model) {
            this.insightId(model.insightId);
            this.groupARN(model.groupARN);
            this.groupName(model.groupName);
            this.rootCauseServiceId(model.rootCauseServiceId);
            this.categoriesWithStrings(model.categories);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.summary(model.summary);
            this.clientRequestImpactStatistics(model.clientRequestImpactStatistics);
            this.rootCauseServiceRequestImpactStatistics(model.rootCauseServiceRequestImpactStatistics);
            this.topAnomalousServices(model.topAnomalousServices);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getInsightId() {
            return this.insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        public final String getGroupARN() {
            return this.groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ServiceId.Builder getRootCauseServiceId() {
            return this.rootCauseServiceId != null ? this.rootCauseServiceId.toBuilder() : null;
        }

        @Override
        public final Builder rootCauseServiceId(ServiceId rootCauseServiceId) {
            this.rootCauseServiceId = rootCauseServiceId;
            return this;
        }

        public final void setRootCauseServiceId(ServiceId.BuilderImpl rootCauseServiceId) {
            this.rootCauseServiceId = rootCauseServiceId != null ? rootCauseServiceId.build() : null;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        @Override
        public final Builder categoriesWithStrings(Collection<String> categories) {
            this.categories = InsightCategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithStrings(String ... categories) {
            this.categoriesWithStrings(Arrays.asList(categories));
            return this;
        }

        @Override
        public final Builder categories(Collection<InsightCategory> categories) {
            this.categories = InsightCategoryListCopier.copyEnumToString(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(InsightCategory ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = InsightCategoryListCopier.copy(categories);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InsightState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final RequestImpactStatistics.Builder getClientRequestImpactStatistics() {
            return this.clientRequestImpactStatistics != null ? this.clientRequestImpactStatistics.toBuilder() : null;
        }

        @Override
        public final Builder clientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
            this.clientRequestImpactStatistics = clientRequestImpactStatistics;
            return this;
        }

        public final void setClientRequestImpactStatistics(RequestImpactStatistics.BuilderImpl clientRequestImpactStatistics) {
            this.clientRequestImpactStatistics = clientRequestImpactStatistics != null ? clientRequestImpactStatistics.build() : null;
        }

        public final RequestImpactStatistics.Builder getRootCauseServiceRequestImpactStatistics() {
            return this.rootCauseServiceRequestImpactStatistics != null ? this.rootCauseServiceRequestImpactStatistics.toBuilder() : null;
        }

        @Override
        public final Builder rootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
            this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics;
            return this;
        }

        public final void setRootCauseServiceRequestImpactStatistics(RequestImpactStatistics.BuilderImpl rootCauseServiceRequestImpactStatistics) {
            this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics != null ? rootCauseServiceRequestImpactStatistics.build() : null;
        }

        public final Collection<AnomalousService.Builder> getTopAnomalousServices() {
            if (this.topAnomalousServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topAnomalousServices != null ? (Collection)this.topAnomalousServices.stream().map(AnomalousService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
            this.topAnomalousServices = AnomalousServiceListCopier.copy(topAnomalousServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAnomalousServices(AnomalousService ... topAnomalousServices) {
            this.topAnomalousServices(Arrays.asList(topAnomalousServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAnomalousServices(Consumer<AnomalousService.Builder> ... topAnomalousServices) {
            this.topAnomalousServices(Stream.of(topAnomalousServices).map(c -> (AnomalousService)((AnomalousService.Builder)AnomalousService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopAnomalousServices(Collection<AnomalousService.BuilderImpl> topAnomalousServices) {
            this.topAnomalousServices = AnomalousServiceListCopier.copyFromBuilder(topAnomalousServices);
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public InsightSummary build() {
            return new InsightSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightSummary> {
        public Builder insightId(String var1);

        public Builder groupARN(String var1);

        public Builder groupName(String var1);

        public Builder rootCauseServiceId(ServiceId var1);

        default public Builder rootCauseServiceId(Consumer<ServiceId.Builder> rootCauseServiceId) {
            return this.rootCauseServiceId((ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation(rootCauseServiceId)).build());
        }

        public Builder categoriesWithStrings(Collection<String> var1);

        public Builder categoriesWithStrings(String ... var1);

        public Builder categories(Collection<InsightCategory> var1);

        public Builder categories(InsightCategory ... var1);

        public Builder state(String var1);

        public Builder state(InsightState var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder summary(String var1);

        public Builder clientRequestImpactStatistics(RequestImpactStatistics var1);

        default public Builder clientRequestImpactStatistics(Consumer<RequestImpactStatistics.Builder> clientRequestImpactStatistics) {
            return this.clientRequestImpactStatistics((RequestImpactStatistics)((RequestImpactStatistics.Builder)RequestImpactStatistics.builder().applyMutation(clientRequestImpactStatistics)).build());
        }

        public Builder rootCauseServiceRequestImpactStatistics(RequestImpactStatistics var1);

        default public Builder rootCauseServiceRequestImpactStatistics(Consumer<RequestImpactStatistics.Builder> rootCauseServiceRequestImpactStatistics) {
            return this.rootCauseServiceRequestImpactStatistics((RequestImpactStatistics)((RequestImpactStatistics.Builder)RequestImpactStatistics.builder().applyMutation(rootCauseServiceRequestImpactStatistics)).build());
        }

        public Builder topAnomalousServices(Collection<AnomalousService> var1);

        public Builder topAnomalousServices(AnomalousService ... var1);

        public Builder topAnomalousServices(Consumer<AnomalousService.Builder> ... var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

