/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.InsightsConfiguration;
import software.amazon.awssdk.services.xray.model.Tag;
import software.amazon.awssdk.services.xray.model.TagListCopier;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGroupRequest.getter(CreateGroupRequest::groupName)).setter(CreateGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGroupRequest.getter(CreateGroupRequest::filterExpression)).setter(CreateGroupRequest.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<InsightsConfiguration> INSIGHTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGroupRequest.getter(CreateGroupRequest::insightsConfiguration)).setter(CreateGroupRequest.setter(Builder::insightsConfiguration)).constructor(InsightsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateGroupRequest.getter(CreateGroupRequest::tags)).setter(CreateGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, FILTER_EXPRESSION_FIELD, INSIGHTS_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String groupName;
    private final String filterExpression;
    private final InsightsConfiguration insightsConfiguration;
    private final List<Tag> tags;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.filterExpression = builder.filterExpression;
        this.insightsConfiguration = builder.insightsConfiguration;
        this.tags = builder.tags;
    }

    public String groupName() {
        return this.groupName;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public InsightsConfiguration insightsConfiguration() {
        return this.insightsConfiguration;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.insightsConfiguration(), other.insightsConfiguration()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateGroupRequest").add("GroupName", (Object)this.groupName()).add("FilterExpression", (Object)this.filterExpression()).add("InsightsConfiguration", (Object)this.insightsConfiguration()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "InsightsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.insightsConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String filterExpression;
        private InsightsConfiguration insightsConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.filterExpression(model.filterExpression);
            this.insightsConfiguration(model.insightsConfiguration);
            this.tags(model.tags);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final InsightsConfiguration.Builder getInsightsConfiguration() {
            return this.insightsConfiguration != null ? this.insightsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder insightsConfiguration(InsightsConfiguration insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        public final void setInsightsConfiguration(InsightsConfiguration.BuilderImpl insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration != null ? insightsConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder groupName(String var1);

        public Builder filterExpression(String var1);

        public Builder insightsConfiguration(InsightsConfiguration var1);

        default public Builder insightsConfiguration(Consumer<InsightsConfiguration.Builder> insightsConfiguration) {
            return this.insightsConfiguration((InsightsConfiguration)((InsightsConfiguration.Builder)InsightsConfiguration.builder().applyMutation(insightsConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

