/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.Service;

public class GetServiceGraphPublisher
implements SdkPublisher<GetServiceGraphResponse> {
    private final XRayAsyncClient client;
    private final GetServiceGraphRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetServiceGraphPublisher(XRayAsyncClient client, GetServiceGraphRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetServiceGraphPublisher(XRayAsyncClient client, GetServiceGraphRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetServiceGraphResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetServiceGraphResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Service> services() {
        Function<GetServiceGraphResponse, Iterator> getIterator = response -> {
            if (response != null && response.services() != null) {
                return response.services().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetServiceGraphResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetServiceGraphPublisher resume(GetServiceGraphResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetServiceGraphPublisher(this.client, (GetServiceGraphRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetServiceGraphPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetServiceGraphResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetServiceGraphResponseFetcher
    implements AsyncPageFetcher<GetServiceGraphResponse> {
        private GetServiceGraphResponseFetcher() {
        }

        public boolean hasNextPage(GetServiceGraphResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetServiceGraphResponse> nextPage(GetServiceGraphResponse previousPage) {
            if (previousPage == null) {
                return GetServiceGraphPublisher.this.client.getServiceGraph(GetServiceGraphPublisher.this.firstRequest);
            }
            return GetServiceGraphPublisher.this.client.getServiceGraph((GetServiceGraphRequest)((Object)GetServiceGraphPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

