/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.xray.model.AnnotationsCopier;
import software.amazon.awssdk.services.xray.model.Http;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.model.TraceUser;
import software.amazon.awssdk.services.xray.model.TraceUsersCopier;
import software.amazon.awssdk.services.xray.model.ValueWithServiceIds;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TraceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TraceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TraceSummary.getter(TraceSummary::id)).setter(TraceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(TraceSummary.getter(TraceSummary::duration)).setter(TraceSummary.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> RESPONSE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(TraceSummary.getter(TraceSummary::responseTime)).setter(TraceSummary.setter(Builder::responseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build()}).build();
    private static final SdkField<Boolean> HAS_FAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TraceSummary.getter(TraceSummary::hasFault)).setter(TraceSummary.setter(Builder::hasFault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasFault").build()}).build();
    private static final SdkField<Boolean> HAS_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TraceSummary.getter(TraceSummary::hasError)).setter(TraceSummary.setter(Builder::hasError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasError").build()}).build();
    private static final SdkField<Boolean> HAS_THROTTLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TraceSummary.getter(TraceSummary::hasThrottle)).setter(TraceSummary.setter(Builder::hasThrottle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasThrottle").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TraceSummary.getter(TraceSummary::isPartial)).setter(TraceSummary.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<Http> HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TraceSummary.getter(TraceSummary::http)).setter(TraceSummary.setter(Builder::http)).constructor(Http::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Http").build()}).build();
    private static final SdkField<Map<String, List<ValueWithServiceIds>>> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TraceSummary.getter(TraceSummary::annotations)).setter(TraceSummary.setter(Builder::annotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValueWithServiceIds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<TraceUser>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TraceSummary.getter(TraceSummary::users)).setter(TraceSummary.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TraceUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TraceSummary.getter(TraceSummary::serviceIds)).setter(TraceSummary.setter(Builder::serviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DURATION_FIELD, RESPONSE_TIME_FIELD, HAS_FAULT_FIELD, HAS_ERROR_FIELD, HAS_THROTTLE_FIELD, IS_PARTIAL_FIELD, HTTP_FIELD, ANNOTATIONS_FIELD, USERS_FIELD, SERVICE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Double duration;
    private final Double responseTime;
    private final Boolean hasFault;
    private final Boolean hasError;
    private final Boolean hasThrottle;
    private final Boolean isPartial;
    private final Http http;
    private final Map<String, List<ValueWithServiceIds>> annotations;
    private final List<TraceUser> users;
    private final List<ServiceId> serviceIds;

    private TraceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.responseTime = builder.responseTime;
        this.hasFault = builder.hasFault;
        this.hasError = builder.hasError;
        this.hasThrottle = builder.hasThrottle;
        this.isPartial = builder.isPartial;
        this.http = builder.http;
        this.annotations = builder.annotations;
        this.users = builder.users;
        this.serviceIds = builder.serviceIds;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public Double responseTime() {
        return this.responseTime;
    }

    public Boolean hasFault() {
        return this.hasFault;
    }

    public Boolean hasError() {
        return this.hasError;
    }

    public Boolean hasThrottle() {
        return this.hasThrottle;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public Http http() {
        return this.http;
    }

    public Map<String, List<ValueWithServiceIds>> annotations() {
        return this.annotations;
    }

    public List<TraceUser> users() {
        return this.users;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFault());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasError());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThrottle());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.http());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotations());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.responseTime(), other.responseTime()) && Objects.equals(this.hasFault(), other.hasFault()) && Objects.equals(this.hasError(), other.hasError()) && Objects.equals(this.hasThrottle(), other.hasThrottle()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.http(), other.http()) && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.users(), other.users()) && Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public String toString() {
        return ToString.builder((String)"TraceSummary").add("Id", (Object)this.id()).add("Duration", (Object)this.duration()).add("ResponseTime", (Object)this.responseTime()).add("HasFault", (Object)this.hasFault()).add("HasError", (Object)this.hasError()).add("HasThrottle", (Object)this.hasThrottle()).add("IsPartial", (Object)this.isPartial()).add("Http", (Object)this.http()).add("Annotations", this.annotations()).add("Users", this.users()).add("ServiceIds", this.serviceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ResponseTime": {
                return Optional.ofNullable(clazz.cast(this.responseTime()));
            }
            case "HasFault": {
                return Optional.ofNullable(clazz.cast(this.hasFault()));
            }
            case "HasError": {
                return Optional.ofNullable(clazz.cast(this.hasError()));
            }
            case "HasThrottle": {
                return Optional.ofNullable(clazz.cast(this.hasThrottle()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "Http": {
                return Optional.ofNullable(clazz.cast(this.http()));
            }
            case "Annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "ServiceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TraceSummary, T> g) {
        return obj -> g.apply((TraceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private Double responseTime;
        private Boolean hasFault;
        private Boolean hasError;
        private Boolean hasThrottle;
        private Boolean isPartial;
        private Http http;
        private Map<String, List<ValueWithServiceIds>> annotations = DefaultSdkAutoConstructMap.getInstance();
        private List<TraceUser> users = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TraceSummary model) {
            this.id(model.id);
            this.duration(model.duration);
            this.responseTime(model.responseTime);
            this.hasFault(model.hasFault);
            this.hasError(model.hasError);
            this.hasThrottle(model.hasThrottle);
            this.isPartial(model.isPartial);
            this.http(model.http);
            this.annotations(model.annotations);
            this.users(model.users);
            this.serviceIds(model.serviceIds);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Double getResponseTime() {
            return this.responseTime;
        }

        @Override
        public final Builder responseTime(Double responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final void setResponseTime(Double responseTime) {
            this.responseTime = responseTime;
        }

        public final Boolean getHasFault() {
            return this.hasFault;
        }

        @Override
        public final Builder hasFault(Boolean hasFault) {
            this.hasFault = hasFault;
            return this;
        }

        public final void setHasFault(Boolean hasFault) {
            this.hasFault = hasFault;
        }

        public final Boolean getHasError() {
            return this.hasError;
        }

        @Override
        public final Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public final void setHasError(Boolean hasError) {
            this.hasError = hasError;
        }

        public final Boolean getHasThrottle() {
            return this.hasThrottle;
        }

        @Override
        public final Builder hasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
            return this;
        }

        public final void setHasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        public final Http.Builder getHttp() {
            return this.http != null ? this.http.toBuilder() : null;
        }

        @Override
        public final Builder http(Http http) {
            this.http = http;
            return this;
        }

        public final void setHttp(Http.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        public final Map<String, ? extends Collection<ValueWithServiceIds>> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final void setAnnotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
        }

        public final Collection<TraceUser.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(TraceUser::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(TraceUser ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<TraceUser.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (TraceUser)((TraceUser.Builder)TraceUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<TraceUser.BuilderImpl> users) {
            this.users = TraceUsersCopier.copyFromBuilder(users);
        }

        public final Collection<ServiceId.Builder> getServiceIds() {
            return this.serviceIds != null ? (Collection)this.serviceIds.stream().map(ServiceId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder> ... serviceIds) {
            this.serviceIds(Stream.of(serviceIds).map(c -> (ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        public TraceSummary build() {
            return new TraceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TraceSummary> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder responseTime(Double var1);

        public Builder hasFault(Boolean var1);

        public Builder hasError(Boolean var1);

        public Builder hasThrottle(Boolean var1);

        public Builder isPartial(Boolean var1);

        public Builder http(Http var1);

        default public Builder http(Consumer<Http.Builder> http) {
            return this.http((Http)((Http.Builder)Http.builder().applyMutation(http)).build());
        }

        public Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> var1);

        public Builder users(Collection<TraceUser> var1);

        public Builder users(TraceUser ... var1);

        public Builder users(Consumer<TraceUser.Builder> ... var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);

        public Builder serviceIds(Consumer<ServiceId.Builder> ... var1);
    }
}

