/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.CertificateSummary;
import software.amazon.awssdk.services.workspacesweb.model.CertificateSummaryListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustStoreCertificatesResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListTrustStoreCertificatesResponse> {
    private static final SdkField<List<CertificateSummary>> CERTIFICATE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateList").getter(ListTrustStoreCertificatesResponse.getter(ListTrustStoreCertificatesResponse::certificateList)).setter(ListTrustStoreCertificatesResponse.setter(Builder::certificateList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustStoreArn").getter(ListTrustStoreCertificatesResponse.getter(ListTrustStoreCertificatesResponse::trustStoreArn)).setter(ListTrustStoreCertificatesResponse.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrustStoreCertificatesResponse.getter(ListTrustStoreCertificatesResponse::nextToken)).setter(ListTrustStoreCertificatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_LIST_FIELD, TRUST_STORE_ARN_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrustStoreCertificatesResponse.memberNameToFieldInitializer();
    private final List<CertificateSummary> certificateList;
    private final String trustStoreArn;
    private final String nextToken;

    private ListTrustStoreCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificateList = builder.certificateList;
        this.trustStoreArn = builder.trustStoreArn;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCertificateList() {
        return this.certificateList != null && !(this.certificateList instanceof SdkAutoConstructList);
    }

    public final List<CertificateSummary> certificateList() {
        return this.certificateList;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateList() ? this.certificateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustStoreCertificatesResponse)) {
            return false;
        }
        ListTrustStoreCertificatesResponse other = (ListTrustStoreCertificatesResponse)((Object)obj);
        return this.hasCertificateList() == other.hasCertificateList() && Objects.equals(this.certificateList(), other.certificateList()) && Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustStoreCertificatesResponse").add("CertificateList", this.hasCertificateList() ? this.certificateList() : null).add("TrustStoreArn", (Object)this.trustStoreArn()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateList": {
                return Optional.ofNullable(clazz.cast(this.certificateList()));
            }
            case "trustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certificateList", CERTIFICATE_LIST_FIELD);
        map.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustStoreCertificatesResponse, T> g) {
        return obj -> g.apply((ListTrustStoreCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private List<CertificateSummary> certificateList = DefaultSdkAutoConstructList.getInstance();
        private String trustStoreArn;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustStoreCertificatesResponse model) {
            super(model);
            this.certificateList(model.certificateList);
            this.trustStoreArn(model.trustStoreArn);
            this.nextToken(model.nextToken);
        }

        public final List<CertificateSummary.Builder> getCertificateList() {
            List<CertificateSummary.Builder> result = CertificateSummaryListCopier.copyToBuilder(this.certificateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateList(Collection<CertificateSummary.BuilderImpl> certificateList) {
            this.certificateList = CertificateSummaryListCopier.copyFromBuilder(certificateList);
        }

        @Override
        public final Builder certificateList(Collection<CertificateSummary> certificateList) {
            this.certificateList = CertificateSummaryListCopier.copy(certificateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateList(CertificateSummary ... certificateList) {
            this.certificateList(Arrays.asList(certificateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateList(Consumer<CertificateSummary.Builder> ... certificateList) {
            this.certificateList(Stream.of(certificateList).map(c -> (CertificateSummary)((CertificateSummary.Builder)CertificateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrustStoreCertificatesResponse build() {
            return new ListTrustStoreCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustStoreCertificatesResponse> {
        public Builder certificateList(Collection<CertificateSummary> var1);

        public Builder certificateList(CertificateSummary ... var1);

        public Builder certificateList(Consumer<CertificateSummary.Builder> ... var1);

        public Builder trustStoreArn(String var1);

        public Builder nextToken(String var1);
    }
}

