/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration;
import software.amazon.awssdk.services.workspacesweb.model.EnabledType;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.ToolbarConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSettings> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(UserSettings.getter(UserSettings::additionalEncryptionContext)).setter(UserSettings.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(UserSettings.getter(UserSettings::associatedPortalArns)).setter(UserSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CookieSynchronizationConfiguration> COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cookieSynchronizationConfiguration").getter(UserSettings.getter(UserSettings::cookieSynchronizationConfiguration)).setter(UserSettings.setter(Builder::cookieSynchronizationConfiguration)).constructor(CookieSynchronizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cookieSynchronizationConfiguration").build()}).build();
    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("copyAllowed").getter(UserSettings.getter(UserSettings::copyAllowedAsString)).setter(UserSettings.setter(Builder::copyAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(UserSettings.getter(UserSettings::customerManagedKey)).setter(UserSettings.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<String> DEEP_LINK_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deepLinkAllowed").getter(UserSettings.getter(UserSettings::deepLinkAllowedAsString)).setter(UserSettings.setter(Builder::deepLinkAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deepLinkAllowed").build()}).build();
    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("disconnectTimeoutInMinutes").getter(UserSettings.getter(UserSettings::disconnectTimeoutInMinutes)).setter(UserSettings.setter(Builder::disconnectTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectTimeoutInMinutes").build()}).build();
    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("downloadAllowed").getter(UserSettings.getter(UserSettings::downloadAllowedAsString)).setter(UserSettings.setter(Builder::downloadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()}).build();
    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleDisconnectTimeoutInMinutes").getter(UserSettings.getter(UserSettings::idleDisconnectTimeoutInMinutes)).setter(UserSettings.setter(Builder::idleDisconnectTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleDisconnectTimeoutInMinutes").build()}).build();
    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pasteAllowed").getter(UserSettings.getter(UserSettings::pasteAllowedAsString)).setter(UserSettings.setter(Builder::pasteAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()}).build();
    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("printAllowed").getter(UserSettings.getter(UserSettings::printAllowedAsString)).setter(UserSettings.setter(Builder::printAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()}).build();
    private static final SdkField<ToolbarConfiguration> TOOLBAR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolbarConfiguration").getter(UserSettings.getter(UserSettings::toolbarConfiguration)).setter(UserSettings.setter(Builder::toolbarConfiguration)).constructor(ToolbarConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolbarConfiguration").build()}).build();
    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadAllowed").getter(UserSettings.getter(UserSettings::uploadAllowedAsString)).setter(UserSettings.setter(Builder::uploadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()}).build();
    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userSettingsArn").getter(UserSettings.getter(UserSettings::userSettingsArn)).setter(UserSettings.setter(Builder::userSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD, COPY_ALLOWED_FIELD, CUSTOMER_MANAGED_KEY_FIELD, DEEP_LINK_ALLOWED_FIELD, DISCONNECT_TIMEOUT_IN_MINUTES_FIELD, DOWNLOAD_ALLOWED_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD, PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD, TOOLBAR_CONFIGURATION_FIELD, UPLOAD_ALLOWED_FIELD, USER_SETTINGS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> additionalEncryptionContext;
    private final List<String> associatedPortalArns;
    private final CookieSynchronizationConfiguration cookieSynchronizationConfiguration;
    private final String copyAllowed;
    private final String customerManagedKey;
    private final String deepLinkAllowed;
    private final Integer disconnectTimeoutInMinutes;
    private final String downloadAllowed;
    private final Integer idleDisconnectTimeoutInMinutes;
    private final String pasteAllowed;
    private final String printAllowed;
    private final ToolbarConfiguration toolbarConfiguration;
    private final String uploadAllowed;
    private final String userSettingsArn;

    private UserSettings(BuilderImpl builder) {
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.cookieSynchronizationConfiguration = builder.cookieSynchronizationConfiguration;
        this.copyAllowed = builder.copyAllowed;
        this.customerManagedKey = builder.customerManagedKey;
        this.deepLinkAllowed = builder.deepLinkAllowed;
        this.disconnectTimeoutInMinutes = builder.disconnectTimeoutInMinutes;
        this.downloadAllowed = builder.downloadAllowed;
        this.idleDisconnectTimeoutInMinutes = builder.idleDisconnectTimeoutInMinutes;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.toolbarConfiguration = builder.toolbarConfiguration;
        this.uploadAllowed = builder.uploadAllowed;
        this.userSettingsArn = builder.userSettingsArn;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final CookieSynchronizationConfiguration cookieSynchronizationConfiguration() {
        return this.cookieSynchronizationConfiguration;
    }

    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(this.copyAllowed);
    }

    public final String copyAllowedAsString() {
        return this.copyAllowed;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final EnabledType deepLinkAllowed() {
        return EnabledType.fromValue(this.deepLinkAllowed);
    }

    public final String deepLinkAllowedAsString() {
        return this.deepLinkAllowed;
    }

    public final Integer disconnectTimeoutInMinutes() {
        return this.disconnectTimeoutInMinutes;
    }

    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(this.downloadAllowed);
    }

    public final String downloadAllowedAsString() {
        return this.downloadAllowed;
    }

    public final Integer idleDisconnectTimeoutInMinutes() {
        return this.idleDisconnectTimeoutInMinutes;
    }

    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(this.pasteAllowed);
    }

    public final String pasteAllowedAsString() {
        return this.pasteAllowed;
    }

    public final EnabledType printAllowed() {
        return EnabledType.fromValue(this.printAllowed);
    }

    public final String printAllowedAsString() {
        return this.printAllowed;
    }

    public final ToolbarConfiguration toolbarConfiguration() {
        return this.toolbarConfiguration;
    }

    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(this.uploadAllowed);
    }

    public final String uploadAllowedAsString() {
        return this.uploadAllowed;
    }

    public final String userSettingsArn() {
        return this.userSettingsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieSynchronizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deepLinkAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleDisconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolbarConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        return this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.cookieSynchronizationConfiguration(), other.cookieSynchronizationConfiguration()) && Objects.equals(this.copyAllowedAsString(), other.copyAllowedAsString()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && Objects.equals(this.deepLinkAllowedAsString(), other.deepLinkAllowedAsString()) && Objects.equals(this.disconnectTimeoutInMinutes(), other.disconnectTimeoutInMinutes()) && Objects.equals(this.downloadAllowedAsString(), other.downloadAllowedAsString()) && Objects.equals(this.idleDisconnectTimeoutInMinutes(), other.idleDisconnectTimeoutInMinutes()) && Objects.equals(this.pasteAllowedAsString(), other.pasteAllowedAsString()) && Objects.equals(this.printAllowedAsString(), other.printAllowedAsString()) && Objects.equals(this.toolbarConfiguration(), other.toolbarConfiguration()) && Objects.equals(this.uploadAllowedAsString(), other.uploadAllowedAsString()) && Objects.equals(this.userSettingsArn(), other.userSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"UserSettings").add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("CookieSynchronizationConfiguration", (Object)(this.cookieSynchronizationConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("CopyAllowed", (Object)this.copyAllowedAsString()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("DeepLinkAllowed", (Object)this.deepLinkAllowedAsString()).add("DisconnectTimeoutInMinutes", (Object)this.disconnectTimeoutInMinutes()).add("DownloadAllowed", (Object)this.downloadAllowedAsString()).add("IdleDisconnectTimeoutInMinutes", (Object)this.idleDisconnectTimeoutInMinutes()).add("PasteAllowed", (Object)this.pasteAllowedAsString()).add("PrintAllowed", (Object)this.printAllowedAsString()).add("ToolbarConfiguration", (Object)this.toolbarConfiguration()).add("UploadAllowed", (Object)this.uploadAllowedAsString()).add("UserSettingsArn", (Object)this.userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "cookieSynchronizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cookieSynchronizationConfiguration()));
            }
            case "copyAllowed": {
                return Optional.ofNullable(clazz.cast(this.copyAllowedAsString()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "deepLinkAllowed": {
                return Optional.ofNullable(clazz.cast(this.deepLinkAllowedAsString()));
            }
            case "disconnectTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimeoutInMinutes()));
            }
            case "downloadAllowed": {
                return Optional.ofNullable(clazz.cast(this.downloadAllowedAsString()));
            }
            case "idleDisconnectTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.idleDisconnectTimeoutInMinutes()));
            }
            case "pasteAllowed": {
                return Optional.ofNullable(clazz.cast(this.pasteAllowedAsString()));
            }
            case "printAllowed": {
                return Optional.ofNullable(clazz.cast(this.printAllowedAsString()));
            }
            case "toolbarConfiguration": {
                return Optional.ofNullable(clazz.cast(this.toolbarConfiguration()));
            }
            case "uploadAllowed": {
                return Optional.ofNullable(clazz.cast(this.uploadAllowedAsString()));
            }
            case "userSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("cookieSynchronizationConfiguration", COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD);
        map.put("copyAllowed", COPY_ALLOWED_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("deepLinkAllowed", DEEP_LINK_ALLOWED_FIELD);
        map.put("disconnectTimeoutInMinutes", DISCONNECT_TIMEOUT_IN_MINUTES_FIELD);
        map.put("downloadAllowed", DOWNLOAD_ALLOWED_FIELD);
        map.put("idleDisconnectTimeoutInMinutes", IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD);
        map.put("pasteAllowed", PASTE_ALLOWED_FIELD);
        map.put("printAllowed", PRINT_ALLOWED_FIELD);
        map.put("toolbarConfiguration", TOOLBAR_CONFIGURATION_FIELD);
        map.put("uploadAllowed", UPLOAD_ALLOWED_FIELD);
        map.put("userSettingsArn", USER_SETTINGS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private CookieSynchronizationConfiguration cookieSynchronizationConfiguration;
        private String copyAllowed;
        private String customerManagedKey;
        private String deepLinkAllowed;
        private Integer disconnectTimeoutInMinutes;
        private String downloadAllowed;
        private Integer idleDisconnectTimeoutInMinutes;
        private String pasteAllowed;
        private String printAllowed;
        private ToolbarConfiguration toolbarConfiguration;
        private String uploadAllowed;
        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.associatedPortalArns(model.associatedPortalArns);
            this.cookieSynchronizationConfiguration(model.cookieSynchronizationConfiguration);
            this.copyAllowed(model.copyAllowed);
            this.customerManagedKey(model.customerManagedKey);
            this.deepLinkAllowed(model.deepLinkAllowed);
            this.disconnectTimeoutInMinutes(model.disconnectTimeoutInMinutes);
            this.downloadAllowed(model.downloadAllowed);
            this.idleDisconnectTimeoutInMinutes(model.idleDisconnectTimeoutInMinutes);
            this.pasteAllowed(model.pasteAllowed);
            this.printAllowed(model.printAllowed);
            this.toolbarConfiguration(model.toolbarConfiguration);
            this.uploadAllowed(model.uploadAllowed);
            this.userSettingsArn(model.userSettingsArn);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final CookieSynchronizationConfiguration.Builder getCookieSynchronizationConfiguration() {
            return this.cookieSynchronizationConfiguration != null ? this.cookieSynchronizationConfiguration.toBuilder() : null;
        }

        public final void setCookieSynchronizationConfiguration(CookieSynchronizationConfiguration.BuilderImpl cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration != null ? cookieSynchronizationConfiguration.build() : null;
        }

        @Override
        public final Builder cookieSynchronizationConfiguration(CookieSynchronizationConfiguration cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
            return this;
        }

        public final String getCopyAllowed() {
            return this.copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final String getDeepLinkAllowed() {
            return this.deepLinkAllowed;
        }

        public final void setDeepLinkAllowed(String deepLinkAllowed) {
            this.deepLinkAllowed = deepLinkAllowed;
        }

        @Override
        public final Builder deepLinkAllowed(String deepLinkAllowed) {
            this.deepLinkAllowed = deepLinkAllowed;
            return this;
        }

        @Override
        public final Builder deepLinkAllowed(EnabledType deepLinkAllowed) {
            this.deepLinkAllowed(deepLinkAllowed == null ? null : deepLinkAllowed.toString());
            return this;
        }

        public final Integer getDisconnectTimeoutInMinutes() {
            return this.disconnectTimeoutInMinutes;
        }

        public final void setDisconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
        }

        @Override
        public final Builder disconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
            return this;
        }

        public final String getDownloadAllowed() {
            return this.downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInMinutes() {
            return this.idleDisconnectTimeoutInMinutes;
        }

        public final void setIdleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
        }

        @Override
        public final Builder idleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
            return this;
        }

        public final String getPasteAllowed() {
            return this.pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return this.printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final ToolbarConfiguration.Builder getToolbarConfiguration() {
            return this.toolbarConfiguration != null ? this.toolbarConfiguration.toBuilder() : null;
        }

        public final void setToolbarConfiguration(ToolbarConfiguration.BuilderImpl toolbarConfiguration) {
            this.toolbarConfiguration = toolbarConfiguration != null ? toolbarConfiguration.build() : null;
        }

        @Override
        public final Builder toolbarConfiguration(ToolbarConfiguration toolbarConfiguration) {
            this.toolbarConfiguration = toolbarConfiguration;
            return this;
        }

        public final String getUploadAllowed() {
            return this.uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        public final String getUserSettingsArn() {
            return this.userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        public UserSettings build() {
            return new UserSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSettings> {
        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder cookieSynchronizationConfiguration(CookieSynchronizationConfiguration var1);

        default public Builder cookieSynchronizationConfiguration(Consumer<CookieSynchronizationConfiguration.Builder> cookieSynchronizationConfiguration) {
            return this.cookieSynchronizationConfiguration((CookieSynchronizationConfiguration)((CookieSynchronizationConfiguration.Builder)CookieSynchronizationConfiguration.builder().applyMutation(cookieSynchronizationConfiguration)).build());
        }

        public Builder copyAllowed(String var1);

        public Builder copyAllowed(EnabledType var1);

        public Builder customerManagedKey(String var1);

        public Builder deepLinkAllowed(String var1);

        public Builder deepLinkAllowed(EnabledType var1);

        public Builder disconnectTimeoutInMinutes(Integer var1);

        public Builder downloadAllowed(String var1);

        public Builder downloadAllowed(EnabledType var1);

        public Builder idleDisconnectTimeoutInMinutes(Integer var1);

        public Builder pasteAllowed(String var1);

        public Builder pasteAllowed(EnabledType var1);

        public Builder printAllowed(String var1);

        public Builder printAllowed(EnabledType var1);

        public Builder toolbarConfiguration(ToolbarConfiguration var1);

        default public Builder toolbarConfiguration(Consumer<ToolbarConfiguration.Builder> toolbarConfiguration) {
            return this.toolbarConfiguration((ToolbarConfiguration)((ToolbarConfiguration.Builder)ToolbarConfiguration.builder().applyMutation(toolbarConfiguration)).build());
        }

        public Builder uploadAllowed(String var1);

        public Builder uploadAllowed(EnabledType var1);

        public Builder userSettingsArn(String var1);
    }
}

