/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.CookieSpecification;
import software.amazon.awssdk.services.workspacesweb.model.CookieSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CookieSynchronizationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CookieSynchronizationConfiguration> {
    private static final SdkField<List<CookieSpecification>> ALLOWLIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowlist").getter(CookieSynchronizationConfiguration.getter(CookieSynchronizationConfiguration::allowlist)).setter(CookieSynchronizationConfiguration.setter(Builder::allowlist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowlist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CookieSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CookieSpecification>> BLOCKLIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blocklist").getter(CookieSynchronizationConfiguration.getter(CookieSynchronizationConfiguration::blocklist)).setter(CookieSynchronizationConfiguration.setter(Builder::blocklist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocklist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CookieSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWLIST_FIELD, BLOCKLIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CookieSynchronizationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CookieSpecification> allowlist;
    private final List<CookieSpecification> blocklist;

    private CookieSynchronizationConfiguration(BuilderImpl builder) {
        this.allowlist = builder.allowlist;
        this.blocklist = builder.blocklist;
    }

    public final boolean hasAllowlist() {
        return this.allowlist != null && !(this.allowlist instanceof SdkAutoConstructList);
    }

    public final List<CookieSpecification> allowlist() {
        return this.allowlist;
    }

    public final boolean hasBlocklist() {
        return this.blocklist != null && !(this.blocklist instanceof SdkAutoConstructList);
    }

    public final List<CookieSpecification> blocklist() {
        return this.blocklist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowlist() ? this.allowlist() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlocklist() ? this.blocklist() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieSynchronizationConfiguration)) {
            return false;
        }
        CookieSynchronizationConfiguration other = (CookieSynchronizationConfiguration)obj;
        return this.hasAllowlist() == other.hasAllowlist() && Objects.equals(this.allowlist(), other.allowlist()) && this.hasBlocklist() == other.hasBlocklist() && Objects.equals(this.blocklist(), other.blocklist());
    }

    public final String toString() {
        return ToString.builder((String)"CookieSynchronizationConfiguration").add("Allowlist", this.hasAllowlist() ? this.allowlist() : null).add("Blocklist", this.hasBlocklist() ? this.blocklist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowlist": {
                return Optional.ofNullable(clazz.cast(this.allowlist()));
            }
            case "blocklist": {
                return Optional.ofNullable(clazz.cast(this.blocklist()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<CookieSpecification>>> map = new HashMap<String, SdkField<List<CookieSpecification>>>();
        map.put("allowlist", ALLOWLIST_FIELD);
        map.put("blocklist", BLOCKLIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CookieSynchronizationConfiguration, T> g) {
        return obj -> g.apply((CookieSynchronizationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CookieSpecification> allowlist = DefaultSdkAutoConstructList.getInstance();
        private List<CookieSpecification> blocklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieSynchronizationConfiguration model) {
            this.allowlist(model.allowlist);
            this.blocklist(model.blocklist);
        }

        public final List<CookieSpecification.Builder> getAllowlist() {
            List<CookieSpecification.Builder> result = CookieSpecificationsCopier.copyToBuilder(this.allowlist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowlist(Collection<CookieSpecification.BuilderImpl> allowlist) {
            this.allowlist = CookieSpecificationsCopier.copyFromBuilder(allowlist);
        }

        @Override
        public final Builder allowlist(Collection<CookieSpecification> allowlist) {
            this.allowlist = CookieSpecificationsCopier.copy(allowlist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowlist(CookieSpecification ... allowlist) {
            this.allowlist(Arrays.asList(allowlist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowlist(Consumer<CookieSpecification.Builder> ... allowlist) {
            this.allowlist(Stream.of(allowlist).map(c -> (CookieSpecification)((CookieSpecification.Builder)CookieSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CookieSpecification.Builder> getBlocklist() {
            List<CookieSpecification.Builder> result = CookieSpecificationsCopier.copyToBuilder(this.blocklist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocklist(Collection<CookieSpecification.BuilderImpl> blocklist) {
            this.blocklist = CookieSpecificationsCopier.copyFromBuilder(blocklist);
        }

        @Override
        public final Builder blocklist(Collection<CookieSpecification> blocklist) {
            this.blocklist = CookieSpecificationsCopier.copy(blocklist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(CookieSpecification ... blocklist) {
            this.blocklist(Arrays.asList(blocklist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(Consumer<CookieSpecification.Builder> ... blocklist) {
            this.blocklist(Stream.of(blocklist).map(c -> (CookieSpecification)((CookieSpecification.Builder)CookieSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CookieSynchronizationConfiguration build() {
            return new CookieSynchronizationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CookieSynchronizationConfiguration> {
        public Builder allowlist(Collection<CookieSpecification> var1);

        public Builder allowlist(CookieSpecification ... var1);

        public Builder allowlist(Consumer<CookieSpecification.Builder> ... var1);

        public Builder blocklist(Collection<CookieSpecification> var1);

        public Builder blocklist(CookieSpecification ... var1);

        public Builder blocklist(Consumer<CookieSpecification.Builder> ... var1);
    }
}

