/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;

public class ListIdentityProvidersPublisher
implements SdkPublisher<ListIdentityProvidersResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListIdentityProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentityProvidersPublisher(WorkSpacesWebAsyncClient client, ListIdentityProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentityProvidersPublisher(WorkSpacesWebAsyncClient client, ListIdentityProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentityProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentityProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIdentityProvidersResponseFetcher
    implements AsyncPageFetcher<ListIdentityProvidersResponse> {
        private ListIdentityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentityProvidersResponse> nextPage(ListIdentityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProvidersPublisher.this.client.listIdentityProviders(ListIdentityProvidersPublisher.this.firstRequest);
            }
            return ListIdentityProvidersPublisher.this.client.listIdentityProviders((ListIdentityProvidersRequest)((Object)ListIdentityProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

