/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workspacesweb.DefaultWorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.DefaultWorkSpacesWebBaseClientBuilder;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClientBuilder;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebServiceClientConfiguration;
import software.amazon.awssdk.services.workspacesweb.endpoints.WorkSpacesWebEndpointProvider;

@SdkInternalApi
final class DefaultWorkSpacesWebAsyncClientBuilder
extends DefaultWorkSpacesWebBaseClientBuilder<WorkSpacesWebAsyncClientBuilder, WorkSpacesWebAsyncClient>
implements WorkSpacesWebAsyncClientBuilder {
    DefaultWorkSpacesWebAsyncClientBuilder() {
    }

    @Override
    public DefaultWorkSpacesWebAsyncClientBuilder endpointProvider(WorkSpacesWebEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkSpacesWebAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWorkSpacesWebAsyncClientBuilder.validateClientOptions(clientConfiguration);
        WorkSpacesWebServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkSpacesWebAsyncClient client = new DefaultWorkSpacesWebAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkSpacesWebServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkSpacesWebServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

