/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.CertificateListCopier;
import software.amazon.awssdk.services.workspacesweb.model.Tag;
import software.amazon.awssdk.services.workspacesweb.model.TagListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustStoreRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, CreateTrustStoreRequest> {
    private static final SdkField<List<SdkBytes>> CERTIFICATE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateList").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::certificateList)).setter(CreateTrustStoreRequest.setter(Builder::certificateList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::clientToken)).setter(CreateTrustStoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::tags)).setter(CreateTrustStoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_LIST_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final List<SdkBytes> certificateList;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.certificateList = builder.certificateList;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final boolean hasCertificateList() {
        return this.certificateList != null && !(this.certificateList instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> certificateList() {
        return this.certificateList;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateList() ? this.certificateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustStoreRequest)) {
            return false;
        }
        CreateTrustStoreRequest other = (CreateTrustStoreRequest)((Object)obj);
        return this.hasCertificateList() == other.hasCertificateList() && Objects.equals(this.certificateList(), other.certificateList()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrustStoreRequest").add("CertificateList", this.hasCertificateList() ? this.certificateList() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateList": {
                return Optional.ofNullable(clazz.cast(this.certificateList()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustStoreRequest, T> g) {
        return obj -> g.apply((CreateTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private List<SdkBytes> certificateList = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustStoreRequest model) {
            super(model);
            this.certificateList(model.certificateList);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final List<ByteBuffer> getCertificateList() {
            if (this.certificateList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateList == null ? null : this.certificateList.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        public final void setCertificateList(Collection<ByteBuffer> certificateList) {
            this.certificateList(certificateList == null ? null : (Collection)certificateList.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder certificateList(Collection<SdkBytes> certificateList) {
            this.certificateList = CertificateListCopier.copy(certificateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateList(SdkBytes ... certificateList) {
            this.certificateList(Arrays.asList(certificateList));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustStoreRequest build() {
            return new CreateTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustStoreRequest> {
        public Builder certificateList(Collection<SdkBytes> var1);

        public Builder certificateList(SdkBytes ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

