/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies volume attachment parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVolumeRequest extends WorkspacesInstancesRequest implements
        ToCopyableBuilder<AssociateVolumeRequest.Builder, AssociateVolumeRequest> {
    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceInstanceId").getter(getter(AssociateVolumeRequest::workspaceInstanceId))
            .setter(setter(Builder::workspaceInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build())
            .build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(AssociateVolumeRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Device")
            .getter(getter(AssociateVolumeRequest::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_INSTANCE_ID_FIELD,
            VOLUME_ID_FIELD, DEVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceInstanceId;

    private final String volumeId;

    private final String device;

    private AssociateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceInstanceId = builder.workspaceInstanceId;
        this.volumeId = builder.volumeId;
        this.device = builder.device;
    }

    /**
     * <p>
     * WorkSpace Instance to attach volume to.
     * </p>
     * 
     * @return WorkSpace Instance to attach volume to.
     */
    public final String workspaceInstanceId() {
        return workspaceInstanceId;
    }

    /**
     * <p>
     * Volume to be attached.
     * </p>
     * 
     * @return Volume to be attached.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Device path for volume attachment.
     * </p>
     * 
     * @return Device path for volume attachment.
     */
    public final String device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVolumeRequest)) {
            return false;
        }
        AssociateVolumeRequest other = (AssociateVolumeRequest) obj;
        return Objects.equals(workspaceInstanceId(), other.workspaceInstanceId()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(device(), other.device());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateVolumeRequest").add("WorkspaceInstanceId", workspaceInstanceId())
                .add("VolumeId", volumeId()).add("Device", device()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceInstanceId":
            return Optional.ofNullable(clazz.cast(workspaceInstanceId()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Device", DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateVolumeRequest, T> g) {
        return obj -> g.apply((AssociateVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkspacesInstancesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateVolumeRequest> {
        /**
         * <p>
         * WorkSpace Instance to attach volume to.
         * </p>
         * 
         * @param workspaceInstanceId
         *        WorkSpace Instance to attach volume to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceInstanceId(String workspaceInstanceId);

        /**
         * <p>
         * Volume to be attached.
         * </p>
         * 
         * @param volumeId
         *        Volume to be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Device path for volume attachment.
         * </p>
         * 
         * @param device
         *        Device path for volume attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkspacesInstancesRequest.BuilderImpl implements Builder {
        private String workspaceInstanceId;

        private String volumeId;

        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVolumeRequest model) {
            super(model);
            workspaceInstanceId(model.workspaceInstanceId);
            volumeId(model.volumeId);
            device(model.device);
        }

        public final String getWorkspaceInstanceId() {
            return workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVolumeRequest build() {
            return new AssociateVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
