/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a pool session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspacesPoolSession implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspacesPoolSession.Builder, WorkspacesPoolSession> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(WorkspacesPoolSession::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(WorkspacesPoolSession::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(WorkspacesPoolSession::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(WorkspacesPoolSession::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(WorkspacesPoolSession::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime").getter(getter(WorkspacesPoolSession::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONFIGURATION_FIELD = SdkField
            .<NetworkAccessConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkAccessConfiguration")
            .getter(getter(WorkspacesPoolSession::networkAccessConfiguration))
            .setter(setter(Builder::networkAccessConfiguration))
            .constructor(NetworkAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAccessConfiguration").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(WorkspacesPoolSession::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(WorkspacesPoolSession::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            CONNECTION_STATE_FIELD, SESSION_ID_FIELD, INSTANCE_ID_FIELD, POOL_ID_FIELD, EXPIRATION_TIME_FIELD,
            NETWORK_ACCESS_CONFIGURATION_FIELD, START_TIME_FIELD, USER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final String connectionState;

    private final String sessionId;

    private final String instanceId;

    private final String poolId;

    private final Instant expirationTime;

    private final NetworkAccessConfiguration networkAccessConfiguration;

    private final Instant startTime;

    private final String userId;

    private WorkspacesPoolSession(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.connectionState = builder.connectionState;
        this.sessionId = builder.sessionId;
        this.instanceId = builder.instanceId;
        this.poolId = builder.poolId;
        this.expirationTime = builder.expirationTime;
        this.networkAccessConfiguration = builder.networkAccessConfiguration;
        this.startTime = builder.startTime;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0 federation
     * (SAML).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
     *         federation (SAML).
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0 federation
     * (SAML).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
     *         federation (SAML).
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * Specifies whether a user is connected to the pool session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link SessionConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return Specifies whether a user is connected to the pool session.
     * @see SessionConnectionState
     */
    public final SessionConnectionState connectionState() {
        return SessionConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * Specifies whether a user is connected to the pool session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link SessionConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return Specifies whether a user is connected to the pool session.
     * @see SessionConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The identifier for the instance hosting the session.
     * </p>
     * 
     * @return The identifier for the instance hosting the session.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the pool.
     * </p>
     * 
     * @return The identifier of the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The time that the pool session ended.
     * </p>
     * 
     * @return The time that the pool session ended.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Describes the network details of the pool.
     * </p>
     * 
     * @return Describes the network details of the pool.
     */
    public final NetworkAccessConfiguration networkAccessConfiguration() {
        return networkAccessConfiguration;
    }

    /**
     * <p>
     * The time that the pool sission started.
     * </p>
     * 
     * @return The time that the pool sission started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The identifier of the user.
     * </p>
     * 
     * @return The identifier of the user.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(networkAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesPoolSession)) {
            return false;
        }
        WorkspacesPoolSession other = (WorkspacesPoolSession) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(poolId(), other.poolId()) && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(networkAccessConfiguration(), other.networkAccessConfiguration())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspacesPoolSession").add("AuthenticationType", authenticationTypeAsString())
                .add("ConnectionState", connectionStateAsString()).add("SessionId", sessionId()).add("InstanceId", instanceId())
                .add("PoolId", poolId()).add("ExpirationTime", expirationTime())
                .add("NetworkAccessConfiguration", networkAccessConfiguration()).add("StartTime", startTime())
                .add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "NetworkAccessConfiguration":
            return Optional.ofNullable(clazz.cast(networkAccessConfiguration()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("ConnectionState", CONNECTION_STATE_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("NetworkAccessConfiguration", NETWORK_ACCESS_CONFIGURATION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("UserId", USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesPoolSession, T> g) {
        return obj -> g.apply((WorkspacesPoolSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspacesPoolSession> {
        /**
         * <p>
         * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
         * federation (SAML).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
         *        federation (SAML).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
         * federation (SAML).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0
         *        federation (SAML).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * Specifies whether a user is connected to the pool session.
         * </p>
         * 
         * @param connectionState
         *        Specifies whether a user is connected to the pool session.
         * @see SessionConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * Specifies whether a user is connected to the pool session.
         * </p>
         * 
         * @param connectionState
         *        Specifies whether a user is connected to the pool session.
         * @see SessionConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionConnectionState
         */
        Builder connectionState(SessionConnectionState connectionState);

        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The identifier for the instance hosting the session.
         * </p>
         * 
         * @param instanceId
         *        The identifier for the instance hosting the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the pool.
         * </p>
         * 
         * @param poolId
         *        The identifier of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The time that the pool session ended.
         * </p>
         * 
         * @param expirationTime
         *        The time that the pool session ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Describes the network details of the pool.
         * </p>
         * 
         * @param networkAccessConfiguration
         *        Describes the network details of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration);

        /**
         * <p>
         * Describes the network details of the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkAccessConfiguration.Builder}
         * avoiding the need to create one manually via {@link NetworkAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkAccessConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #networkAccessConfiguration(NetworkAccessConfiguration)}.
         * 
         * @param networkAccessConfiguration
         *        a consumer that will call methods on {@link NetworkAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAccessConfiguration(NetworkAccessConfiguration)
         */
        default Builder networkAccessConfiguration(Consumer<NetworkAccessConfiguration.Builder> networkAccessConfiguration) {
            return networkAccessConfiguration(NetworkAccessConfiguration.builder().applyMutation(networkAccessConfiguration)
                    .build());
        }

        /**
         * <p>
         * The time that the pool sission started.
         * </p>
         * 
         * @param startTime
         *        The time that the pool sission started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The identifier of the user.
         * </p>
         * 
         * @param userId
         *        The identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private String connectionState;

        private String sessionId;

        private String instanceId;

        private String poolId;

        private Instant expirationTime;

        private NetworkAccessConfiguration networkAccessConfiguration;

        private Instant startTime;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesPoolSession model) {
            authenticationType(model.authenticationType);
            connectionState(model.connectionState);
            sessionId(model.sessionId);
            instanceId(model.instanceId);
            poolId(model.poolId);
            expirationTime(model.expirationTime);
            networkAccessConfiguration(model.networkAccessConfiguration);
            startTime(model.startTime);
            userId(model.userId);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(SessionConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessConfiguration() {
            return networkAccessConfiguration != null ? networkAccessConfiguration.toBuilder() : null;
        }

        public final void setNetworkAccessConfiguration(NetworkAccessConfiguration.BuilderImpl networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration != null ? networkAccessConfiguration.build() : null;
        }

        @Override
        public final Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public WorkspacesPoolSession build() {
            return new WorkspacesPoolSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
