/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspacesPoolRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<UpdateWorkspacesPoolRequest.Builder, UpdateWorkspacesPoolRequest> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(UpdateWorkspacesPoolRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWorkspacesPoolRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(UpdateWorkspacesPoolRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(UpdateWorkspacesPoolRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.<Capacity> builder(MarshallingType.SDK_POJO)
            .memberName("Capacity").getter(getter(UpdateWorkspacesPoolRequest::capacity)).setter(setter(Builder::capacity))
            .constructor(Capacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<ApplicationSettingsRequest> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettingsRequest> builder(MarshallingType.SDK_POJO).memberName("ApplicationSettings")
            .getter(getter(UpdateWorkspacesPoolRequest::applicationSettings)).setter(setter(Builder::applicationSettings))
            .constructor(ApplicationSettingsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField
            .<TimeoutSettings> builder(MarshallingType.SDK_POJO).memberName("TimeoutSettings")
            .getter(getter(UpdateWorkspacesPoolRequest::timeoutSettings)).setter(setter(Builder::timeoutSettings))
            .constructor(TimeoutSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()).build();

    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunningMode").getter(getter(UpdateWorkspacesPoolRequest::runningModeAsString))
            .setter(setter(Builder::runningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            DESCRIPTION_FIELD, BUNDLE_ID_FIELD, DIRECTORY_ID_FIELD, CAPACITY_FIELD, APPLICATION_SETTINGS_FIELD,
            TIMEOUT_SETTINGS_FIELD, RUNNING_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolId;

    private final String description;

    private final String bundleId;

    private final String directoryId;

    private final Capacity capacity;

    private final ApplicationSettingsRequest applicationSettings;

    private final TimeoutSettings timeoutSettings;

    private final String runningMode;

    private UpdateWorkspacesPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.capacity = builder.capacity;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
        this.runningMode = builder.runningMode;
    }

    /**
     * <p>
     * The identifier of the specified pool to update.
     * </p>
     * 
     * @return The identifier of the specified pool to update.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Describes the specified pool to update.
     * </p>
     * 
     * @return Describes the specified pool to update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the bundle.
     * </p>
     * 
     * @return The identifier of the bundle.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The desired capacity for the pool.
     * </p>
     * 
     * @return The desired capacity for the pool.
     */
    public final Capacity capacity() {
        return capacity;
    }

    /**
     * <p>
     * The persistent application settings for users in the pool.
     * </p>
     * 
     * @return The persistent application settings for users in the pool.
     */
    public final ApplicationSettingsRequest applicationSettings() {
        return applicationSettings;
    }

    /**
     * <p>
     * Indicates the timeout settings of the specified pool.
     * </p>
     * 
     * @return Indicates the timeout settings of the specified pool.
     */
    public final TimeoutSettings timeoutSettings() {
        return timeoutSettings;
    }

    /**
     * <p>
     * The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped
     *         state.
     * @see PoolsRunningMode
     */
    public final PoolsRunningMode runningMode() {
        return PoolsRunningMode.fromValue(runningMode);
    }

    /**
     * <p>
     * The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped
     *         state.
     * @see PoolsRunningMode
     */
    public final String runningModeAsString() {
        return runningMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(runningModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspacesPoolRequest)) {
            return false;
        }
        UpdateWorkspacesPoolRequest other = (UpdateWorkspacesPoolRequest) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(description(), other.description())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(capacity(), other.capacity())
                && Objects.equals(applicationSettings(), other.applicationSettings())
                && Objects.equals(timeoutSettings(), other.timeoutSettings())
                && Objects.equals(runningModeAsString(), other.runningModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspacesPoolRequest").add("PoolId", poolId()).add("Description", description())
                .add("BundleId", bundleId()).add("DirectoryId", directoryId()).add("Capacity", capacity())
                .add("ApplicationSettings", applicationSettings()).add("TimeoutSettings", timeoutSettings())
                .add("RunningMode", runningModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "TimeoutSettings":
            return Optional.ofNullable(clazz.cast(timeoutSettings()));
        case "RunningMode":
            return Optional.ofNullable(clazz.cast(runningModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("ApplicationSettings", APPLICATION_SETTINGS_FIELD);
        map.put("TimeoutSettings", TIMEOUT_SETTINGS_FIELD);
        map.put("RunningMode", RUNNING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspacesPoolRequest, T> g) {
        return obj -> g.apply((UpdateWorkspacesPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspacesPoolRequest> {
        /**
         * <p>
         * The identifier of the specified pool to update.
         * </p>
         * 
         * @param poolId
         *        The identifier of the specified pool to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Describes the specified pool to update.
         * </p>
         * 
         * @param description
         *        Describes the specified pool to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the bundle.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The desired capacity for the pool.
         * </p>
         * 
         * @param capacity
         *        The desired capacity for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Capacity capacity);

        /**
         * <p>
         * The desired capacity for the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capacity.Builder} avoiding the need to
         * create one manually via {@link Capacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capacity.Builder#build()} is called immediately and its result is
         * passed to {@link #capacity(Capacity)}.
         * 
         * @param capacity
         *        a consumer that will call methods on {@link Capacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacity(Capacity)
         */
        default Builder capacity(Consumer<Capacity.Builder> capacity) {
            return capacity(Capacity.builder().applyMutation(capacity).build());
        }

        /**
         * <p>
         * The persistent application settings for users in the pool.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users in the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettingsRequest applicationSettings);

        /**
         * <p>
         * The persistent application settings for users in the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSettingsRequest.Builder}
         * avoiding the need to create one manually via {@link ApplicationSettingsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSettingsRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSettings(ApplicationSettingsRequest)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettingsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettingsRequest)
         */
        default Builder applicationSettings(Consumer<ApplicationSettingsRequest.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettingsRequest.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * Indicates the timeout settings of the specified pool.
         * </p>
         * 
         * @param timeoutSettings
         *        Indicates the timeout settings of the specified pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSettings(TimeoutSettings timeoutSettings);

        /**
         * <p>
         * Indicates the timeout settings of the specified pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeoutSettings.Builder} avoiding the
         * need to create one manually via {@link TimeoutSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutSettings(TimeoutSettings)}.
         * 
         * @param timeoutSettings
         *        a consumer that will call methods on {@link TimeoutSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutSettings(TimeoutSettings)
         */
        default Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return timeoutSettings(TimeoutSettings.builder().applyMutation(timeoutSettings).build());
        }

        /**
         * <p>
         * The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped
         * state.
         * </p>
         * 
         * @param runningMode
         *        The desired running mode for the pool. The running mode can only be updated when the pool is in a
         *        stopped state.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(String runningMode);

        /**
         * <p>
         * The desired running mode for the pool. The running mode can only be updated when the pool is in a stopped
         * state.
         * </p>
         * 
         * @param runningMode
         *        The desired running mode for the pool. The running mode can only be updated when the pool is in a
         *        stopped state.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(PoolsRunningMode runningMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String poolId;

        private String description;

        private String bundleId;

        private String directoryId;

        private Capacity capacity;

        private ApplicationSettingsRequest applicationSettings;

        private TimeoutSettings timeoutSettings;

        private String runningMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspacesPoolRequest model) {
            super(model);
            poolId(model.poolId);
            description(model.description);
            bundleId(model.bundleId);
            directoryId(model.directoryId);
            capacity(model.capacity);
            applicationSettings(model.applicationSettings);
            timeoutSettings(model.timeoutSettings);
            runningMode(model.runningMode);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Capacity.Builder getCapacity() {
            return capacity != null ? capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final ApplicationSettingsRequest.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsRequest.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsRequest applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return timeoutSettings != null ? timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        public final String getRunningMode() {
            return runningMode;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(PoolsRunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspacesPoolRequest build() {
            return new UpdateWorkspacesPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
