/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the streaming properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingProperties.Builder, StreamingProperties> {
    private static final SdkField<String> STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StreamingExperiencePreferredProtocol")
            .getter(getter(StreamingProperties::streamingExperiencePreferredProtocolAsString))
            .setter(setter(Builder::streamingExperiencePreferredProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("StreamingExperiencePreferredProtocol").build()).build();

    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField
            .<List<UserSetting>> builder(MarshallingType.LIST)
            .memberName("UserSettings")
            .getter(getter(StreamingProperties::userSettings))
            .setter(setter(Builder::userSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField
            .<List<StorageConnector>> builder(MarshallingType.LIST)
            .memberName("StorageConnectors")
            .getter(getter(StreamingProperties::storageConnectors))
            .setter(setter(Builder::storageConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConnector> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConnector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GlobalAcceleratorForDirectory> GLOBAL_ACCELERATOR_FIELD = SdkField
            .<GlobalAcceleratorForDirectory> builder(MarshallingType.SDK_POJO).memberName("GlobalAccelerator")
            .getter(getter(StreamingProperties::globalAccelerator)).setter(setter(Builder::globalAccelerator))
            .constructor(GlobalAcceleratorForDirectory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalAccelerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD, USER_SETTINGS_FIELD, STORAGE_CONNECTORS_FIELD,
            GLOBAL_ACCELERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamingExperiencePreferredProtocol;

    private final List<UserSetting> userSettings;

    private final List<StorageConnector> storageConnectors;

    private final GlobalAcceleratorForDirectory globalAccelerator;

    private StreamingProperties(BuilderImpl builder) {
        this.streamingExperiencePreferredProtocol = builder.streamingExperiencePreferredProtocol;
        this.userSettings = builder.userSettings;
        this.storageConnectors = builder.storageConnectors;
        this.globalAccelerator = builder.globalAccelerator;
    }

    /**
     * <p>
     * Indicates the type of preferred protocol for the streaming experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamingExperiencePreferredProtocol} will return
     * {@link StreamingExperiencePreferredProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #streamingExperiencePreferredProtocolAsString}.
     * </p>
     * 
     * @return Indicates the type of preferred protocol for the streaming experience.
     * @see StreamingExperiencePreferredProtocolEnum
     */
    public final StreamingExperiencePreferredProtocolEnum streamingExperiencePreferredProtocol() {
        return StreamingExperiencePreferredProtocolEnum.fromValue(streamingExperiencePreferredProtocol);
    }

    /**
     * <p>
     * Indicates the type of preferred protocol for the streaming experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamingExperiencePreferredProtocol} will return
     * {@link StreamingExperiencePreferredProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #streamingExperiencePreferredProtocolAsString}.
     * </p>
     * 
     * @return Indicates the type of preferred protocol for the streaming experience.
     * @see StreamingExperiencePreferredProtocolEnum
     */
    public final String streamingExperiencePreferredProtocolAsString() {
        return streamingExperiencePreferredProtocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserSettings() {
        return userSettings != null && !(userSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the permission settings asscoiated with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserSettings} method.
     * </p>
     * 
     * @return Indicates the permission settings asscoiated with the user.
     */
    public final List<UserSetting> userSettings() {
        return userSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConnectors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageConnectors() {
        return storageConnectors != null && !(storageConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the storage connector used
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConnectors} method.
     * </p>
     * 
     * @return Indicates the storage connector used
     */
    public final List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * Indicates the Global Accelerator properties.
     * </p>
     * 
     * @return Indicates the Global Accelerator properties.
     */
    public final GlobalAcceleratorForDirectory globalAccelerator() {
        return globalAccelerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingExperiencePreferredProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserSettings() ? userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConnectors() ? storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(globalAccelerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingProperties)) {
            return false;
        }
        StreamingProperties other = (StreamingProperties) obj;
        return Objects.equals(streamingExperiencePreferredProtocolAsString(),
                other.streamingExperiencePreferredProtocolAsString())
                && hasUserSettings() == other.hasUserSettings()
                && Objects.equals(userSettings(), other.userSettings())
                && hasStorageConnectors() == other.hasStorageConnectors()
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(globalAccelerator(), other.globalAccelerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingProperties")
                .add("StreamingExperiencePreferredProtocol", streamingExperiencePreferredProtocolAsString())
                .add("UserSettings", hasUserSettings() ? userSettings() : null)
                .add("StorageConnectors", hasStorageConnectors() ? storageConnectors() : null)
                .add("GlobalAccelerator", globalAccelerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingExperiencePreferredProtocol":
            return Optional.ofNullable(clazz.cast(streamingExperiencePreferredProtocolAsString()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "GlobalAccelerator":
            return Optional.ofNullable(clazz.cast(globalAccelerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamingExperiencePreferredProtocol", STREAMING_EXPERIENCE_PREFERRED_PROTOCOL_FIELD);
        map.put("UserSettings", USER_SETTINGS_FIELD);
        map.put("StorageConnectors", STORAGE_CONNECTORS_FIELD);
        map.put("GlobalAccelerator", GLOBAL_ACCELERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingProperties, T> g) {
        return obj -> g.apply((StreamingProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingProperties> {
        /**
         * <p>
         * Indicates the type of preferred protocol for the streaming experience.
         * </p>
         * 
         * @param streamingExperiencePreferredProtocol
         *        Indicates the type of preferred protocol for the streaming experience.
         * @see StreamingExperiencePreferredProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingExperiencePreferredProtocolEnum
         */
        Builder streamingExperiencePreferredProtocol(String streamingExperiencePreferredProtocol);

        /**
         * <p>
         * Indicates the type of preferred protocol for the streaming experience.
         * </p>
         * 
         * @param streamingExperiencePreferredProtocol
         *        Indicates the type of preferred protocol for the streaming experience.
         * @see StreamingExperiencePreferredProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingExperiencePreferredProtocolEnum
         */
        Builder streamingExperiencePreferredProtocol(StreamingExperiencePreferredProtocolEnum streamingExperiencePreferredProtocol);

        /**
         * <p>
         * Indicates the permission settings asscoiated with the user.
         * </p>
         * 
         * @param userSettings
         *        Indicates the permission settings asscoiated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSetting> userSettings);

        /**
         * <p>
         * Indicates the permission settings asscoiated with the user.
         * </p>
         * 
         * @param userSettings
         *        Indicates the permission settings asscoiated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSetting... userSettings);

        /**
         * <p>
         * Indicates the permission settings asscoiated with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.UserSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspaces.model.UserSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.UserSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #userSettings(List<UserSetting>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.UserSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(java.util.Collection<UserSetting>)
         */
        Builder userSettings(Consumer<UserSetting.Builder>... userSettings);

        /**
         * <p>
         * Indicates the storage connector used
         * </p>
         * 
         * @param storageConnectors
         *        Indicates the storage connector used
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * Indicates the storage connector used
         * </p>
         * 
         * @param storageConnectors
         *        Indicates the storage connector used
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * Indicates the storage connector used
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.StorageConnector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.StorageConnector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.StorageConnector.Builder#build()} is called
         * immediately and its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.StorageConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(java.util.Collection<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * Indicates the Global Accelerator properties.
         * </p>
         * 
         * @param globalAccelerator
         *        Indicates the Global Accelerator properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalAccelerator(GlobalAcceleratorForDirectory globalAccelerator);

        /**
         * <p>
         * Indicates the Global Accelerator properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalAcceleratorForDirectory.Builder}
         * avoiding the need to create one manually via {@link GlobalAcceleratorForDirectory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalAcceleratorForDirectory.Builder#build()} is called
         * immediately and its result is passed to {@link #globalAccelerator(GlobalAcceleratorForDirectory)}.
         * 
         * @param globalAccelerator
         *        a consumer that will call methods on {@link GlobalAcceleratorForDirectory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalAccelerator(GlobalAcceleratorForDirectory)
         */
        default Builder globalAccelerator(Consumer<GlobalAcceleratorForDirectory.Builder> globalAccelerator) {
            return globalAccelerator(GlobalAcceleratorForDirectory.builder().applyMutation(globalAccelerator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String streamingExperiencePreferredProtocol;

        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private GlobalAcceleratorForDirectory globalAccelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingProperties model) {
            streamingExperiencePreferredProtocol(model.streamingExperiencePreferredProtocol);
            userSettings(model.userSettings);
            storageConnectors(model.storageConnectors);
            globalAccelerator(model.globalAccelerator);
        }

        public final String getStreamingExperiencePreferredProtocol() {
            return streamingExperiencePreferredProtocol;
        }

        public final void setStreamingExperiencePreferredProtocol(String streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol = streamingExperiencePreferredProtocol;
        }

        @Override
        public final Builder streamingExperiencePreferredProtocol(String streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol = streamingExperiencePreferredProtocol;
            return this;
        }

        @Override
        public final Builder streamingExperiencePreferredProtocol(
                StreamingExperiencePreferredProtocolEnum streamingExperiencePreferredProtocol) {
            this.streamingExperiencePreferredProtocol(streamingExperiencePreferredProtocol == null ? null
                    : streamingExperiencePreferredProtocol.toString());
            return this;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingsCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingsCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingsCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorsCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorsCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorsCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GlobalAcceleratorForDirectory.Builder getGlobalAccelerator() {
            return globalAccelerator != null ? globalAccelerator.toBuilder() : null;
        }

        public final void setGlobalAccelerator(GlobalAcceleratorForDirectory.BuilderImpl globalAccelerator) {
            this.globalAccelerator = globalAccelerator != null ? globalAccelerator.build() : null;
        }

        @Override
        public final Builder globalAccelerator(GlobalAcceleratorForDirectory globalAccelerator) {
            this.globalAccelerator = globalAccelerator;
            return this;
        }

        @Override
        public StreamingProperties build() {
            return new StreamingProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
