/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the related WorkSpace. The related WorkSpace could be a standby WorkSpace or primary WorkSpace related to
 * the specified WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedWorkspaceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedWorkspaceProperties.Builder, RelatedWorkspaceProperties> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(RelatedWorkspaceProperties::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RelatedWorkspaceProperties::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RelatedWorkspaceProperties::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RelatedWorkspaceProperties::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            REGION_FIELD, STATE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final String region;

    private final String state;

    private final String type;

    private RelatedWorkspaceProperties(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.region = builder.region;
        this.state = builder.state;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the related WorkSpace.
     * </p>
     * 
     * @return The identifier of the related WorkSpace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The Region of the related WorkSpace.
     * </p>
     * 
     * @return The Region of the related WorkSpace.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Indicates the state of the WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the state of the WorkSpace.
     * @see WorkspaceState
     */
    public final WorkspaceState state() {
        return WorkspaceState.fromValue(state);
    }

    /**
     * <p>
     * Indicates the state of the WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the state of the WorkSpace.
     * @see WorkspaceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Indicates the type of WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StandbyWorkspaceRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of WorkSpace.
     * @see StandbyWorkspaceRelationshipType
     */
    public final StandbyWorkspaceRelationshipType type() {
        return StandbyWorkspaceRelationshipType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StandbyWorkspaceRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of WorkSpace.
     * @see StandbyWorkspaceRelationshipType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedWorkspaceProperties)) {
            return false;
        }
        RelatedWorkspaceProperties other = (RelatedWorkspaceProperties) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(region(), other.region())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedWorkspaceProperties").add("WorkspaceId", workspaceId()).add("Region", region())
                .add("State", stateAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedWorkspaceProperties, T> g) {
        return obj -> g.apply((RelatedWorkspaceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedWorkspaceProperties> {
        /**
         * <p>
         * The identifier of the related WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the related WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The Region of the related WorkSpace.
         * </p>
         * 
         * @param region
         *        The Region of the related WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Indicates the state of the WorkSpace.
         * </p>
         * 
         * @param state
         *        Indicates the state of the WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates the state of the WorkSpace.
         * </p>
         * 
         * @param state
         *        Indicates the state of the WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(WorkspaceState state);

        /**
         * <p>
         * Indicates the type of WorkSpace.
         * </p>
         * 
         * @param type
         *        Indicates the type of WorkSpace.
         * @see StandbyWorkspaceRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyWorkspaceRelationshipType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of WorkSpace.
         * </p>
         * 
         * @param type
         *        Indicates the type of WorkSpace.
         * @see StandbyWorkspaceRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyWorkspaceRelationshipType
         */
        Builder type(StandbyWorkspaceRelationshipType type);
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private String region;

        private String state;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedWorkspaceProperties model) {
            workspaceId(model.workspaceId);
            region(model.region);
            state(model.state);
            type(model.type);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StandbyWorkspaceRelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RelatedWorkspaceProperties build() {
            return new RelatedWorkspaceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
