/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebuildWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<RebuildWorkspacesRequest.Builder, RebuildWorkspacesRequest> {
    private static final SdkField<List<RebuildRequest>> REBUILD_WORKSPACE_REQUESTS_FIELD = SdkField
            .<List<RebuildRequest>> builder(MarshallingType.LIST)
            .memberName("RebuildWorkspaceRequests")
            .getter(getter(RebuildWorkspacesRequest::rebuildWorkspaceRequests))
            .setter(setter(Builder::rebuildWorkspaceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspaceRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RebuildRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RebuildRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REBUILD_WORKSPACE_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RebuildRequest> rebuildWorkspaceRequests;

    private RebuildWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.rebuildWorkspaceRequests = builder.rebuildWorkspaceRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the RebuildWorkspaceRequests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRebuildWorkspaceRequests() {
        return rebuildWorkspaceRequests != null && !(rebuildWorkspaceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The WorkSpace to rebuild. You can specify a single WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRebuildWorkspaceRequests} method.
     * </p>
     * 
     * @return The WorkSpace to rebuild. You can specify a single WorkSpace.
     */
    public final List<RebuildRequest> rebuildWorkspaceRequests() {
        return rebuildWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRebuildWorkspaceRequests() ? rebuildWorkspaceRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebuildWorkspacesRequest)) {
            return false;
        }
        RebuildWorkspacesRequest other = (RebuildWorkspacesRequest) obj;
        return hasRebuildWorkspaceRequests() == other.hasRebuildWorkspaceRequests()
                && Objects.equals(rebuildWorkspaceRequests(), other.rebuildWorkspaceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RebuildWorkspacesRequest")
                .add("RebuildWorkspaceRequests", hasRebuildWorkspaceRequests() ? rebuildWorkspaceRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RebuildWorkspaceRequests":
            return Optional.ofNullable(clazz.cast(rebuildWorkspaceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RebuildWorkspaceRequests", REBUILD_WORKSPACE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RebuildWorkspacesRequest, T> g) {
        return obj -> g.apply((RebuildWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, RebuildWorkspacesRequest> {
        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * 
         * @param rebuildWorkspaceRequests
         *        The WorkSpace to rebuild. You can specify a single WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests);

        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * 
         * @param rebuildWorkspaceRequests
         *        The WorkSpace to rebuild. You can specify a single WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildWorkspaceRequests(RebuildRequest... rebuildWorkspaceRequests);

        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.RebuildRequest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.RebuildRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.RebuildRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #rebuildWorkspaceRequests(List<RebuildRequest>)}.
         * 
         * @param rebuildWorkspaceRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.RebuildRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rebuildWorkspaceRequests(java.util.Collection<RebuildRequest>)
         */
        Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder>... rebuildWorkspaceRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<RebuildRequest> rebuildWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebuildWorkspacesRequest model) {
            super(model);
            rebuildWorkspaceRequests(model.rebuildWorkspaceRequests);
        }

        public final List<RebuildRequest.Builder> getRebuildWorkspaceRequests() {
            List<RebuildRequest.Builder> result = RebuildWorkspaceRequestsCopier.copyToBuilder(this.rebuildWorkspaceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRebuildWorkspaceRequests(Collection<RebuildRequest.BuilderImpl> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copyFromBuilder(rebuildWorkspaceRequests);
        }

        @Override
        public final Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copy(rebuildWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(RebuildRequest... rebuildWorkspaceRequests) {
            rebuildWorkspaceRequests(Arrays.asList(rebuildWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder>... rebuildWorkspaceRequests) {
            rebuildWorkspaceRequests(Stream.of(rebuildWorkspaceRequests)
                    .map(c -> RebuildRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebuildWorkspacesRequest build() {
            return new RebuildWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
