/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule for an IP access control group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpRuleItem implements SdkPojo, Serializable, ToCopyableBuilder<IpRuleItem.Builder, IpRuleItem> {
    private static final SdkField<String> IP_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ipRule")
            .getter(getter(IpRuleItem::ipRule)).setter(setter(Builder::ipRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipRule").build()).build();

    private static final SdkField<String> RULE_DESC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleDesc").getter(getter(IpRuleItem::ruleDesc)).setter(setter(Builder::ruleDesc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDesc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IP_RULE_FIELD, RULE_DESC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipRule;

    private final String ruleDesc;

    private IpRuleItem(BuilderImpl builder) {
        this.ipRule = builder.ipRule;
        this.ruleDesc = builder.ruleDesc;
    }

    /**
     * <p>
     * The IP address range, in CIDR notation.
     * </p>
     * 
     * @return The IP address range, in CIDR notation.
     */
    public final String ipRule() {
        return ipRule;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String ruleDesc() {
        return ruleDesc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipRule());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDesc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRuleItem)) {
            return false;
        }
        IpRuleItem other = (IpRuleItem) obj;
        return Objects.equals(ipRule(), other.ipRule()) && Objects.equals(ruleDesc(), other.ruleDesc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpRuleItem").add("IpRule", ipRule()).add("RuleDesc", ruleDesc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipRule":
            return Optional.ofNullable(clazz.cast(ipRule()));
        case "ruleDesc":
            return Optional.ofNullable(clazz.cast(ruleDesc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ipRule", IP_RULE_FIELD);
        map.put("ruleDesc", RULE_DESC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpRuleItem, T> g) {
        return obj -> g.apply((IpRuleItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpRuleItem> {
        /**
         * <p>
         * The IP address range, in CIDR notation.
         * </p>
         * 
         * @param ipRule
         *        The IP address range, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRule(String ipRule);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param ruleDesc
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDesc(String ruleDesc);
    }

    static final class BuilderImpl implements Builder {
        private String ipRule;

        private String ruleDesc;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRuleItem model) {
            ipRule(model.ipRule);
            ruleDesc(model.ruleDesc);
        }

        public final String getIpRule() {
            return ipRule;
        }

        public final void setIpRule(String ipRule) {
            this.ipRule = ipRule;
        }

        @Override
        public final Builder ipRule(String ipRule) {
            this.ipRule = ipRule;
            return this;
        }

        public final String getRuleDesc() {
            return ruleDesc;
        }

        public final void setRuleDesc(String ruleDesc) {
            this.ruleDesc = ruleDesc;
        }

        @Override
        public final Builder ruleDesc(String ruleDesc) {
            this.ruleDesc = ruleDesc;
            return this;
        }

        @Override
        public IpRuleItem build() {
            return new IpRuleItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
