/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspacesRequest.Builder, DescribeWorkspacesRequest> {
    private static final SdkField<List<String>> WORKSPACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WorkspaceIds")
            .getter(getter(DescribeWorkspacesRequest::workspaceIds))
            .setter(setter(Builder::workspaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeWorkspacesRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(DescribeWorkspacesRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(DescribeWorkspacesRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeWorkspacesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceName").getter(getter(DescribeWorkspacesRequest::workspaceName))
            .setter(setter(Builder::workspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_IDS_FIELD,
            DIRECTORY_ID_FIELD, USER_NAME_FIELD, BUNDLE_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD, WORKSPACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> workspaceIds;

    private final String directoryId;

    private final String userName;

    private final String bundleId;

    private final Integer limit;

    private final String nextToken;

    private final String workspaceName;

    private DescribeWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceIds = builder.workspaceIds;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.bundleId = builder.bundleId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.workspaceName = builder.workspaceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkspaceIds() {
        return workspaceIds != null && !(workspaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.
     * </p>
     * <p>
     * Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not immediately
     * available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceIds} method.
     * </p>
     * 
     * @return The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
     *         <p>
     *         Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not
     *         immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no
     *         information is returned.
     */
    public final List<String> workspaceIds() {
        return workspaceIds;
    }

    /**
     * <p>
     * The identifier of the directory. In addition, you can optionally specify a specific directory user (see
     * <code>UserName</code>). You cannot combine this parameter with any other filter.
     * </p>
     * 
     * @return The identifier of the directory. In addition, you can optionally specify a specific directory user (see
     *         <code>UserName</code>). You cannot combine this parameter with any other filter.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.
     * </p>
     * 
     * @return The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine
     * this parameter with any other filter.
     * </p>
     * 
     * @return The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot
     *         combine this parameter with any other filter.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The maximum number of items to return.
     * </p>
     * 
     * @return The maximum number of items to return.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the user-decoupled WorkSpace.
     * </p>
     * 
     * @return The name of the user-decoupled WorkSpace.
     */
    public final String workspaceName() {
        return workspaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceIds() ? workspaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesRequest)) {
            return false;
        }
        DescribeWorkspacesRequest other = (DescribeWorkspacesRequest) obj;
        return hasWorkspaceIds() == other.hasWorkspaceIds() && Objects.equals(workspaceIds(), other.workspaceIds())
                && Objects.equals(directoryId(), other.directoryId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workspaceName(), other.workspaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesRequest").add("WorkspaceIds", hasWorkspaceIds() ? workspaceIds() : null)
                .add("DirectoryId", directoryId()).add("UserName", userName()).add("BundleId", bundleId()).add("Limit", limit())
                .add("NextToken", nextToken()).add("WorkspaceName", workspaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceIds":
            return Optional.ofNullable(clazz.cast(workspaceIds()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WorkspaceName":
            return Optional.ofNullable(clazz.cast(workspaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceIds", WORKSPACE_IDS_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkspaceName", WORKSPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkspacesRequest> {
        /**
         * <p>
         * The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.
         * </p>
         * <p>
         * Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not immediately
         * available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is
         * returned.
         * </p>
         * 
         * @param workspaceIds
         *        The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
         *        <p>
         *        Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not
         *        immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no
         *        information is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceIds(Collection<String> workspaceIds);

        /**
         * <p>
         * The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.
         * </p>
         * <p>
         * Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not immediately
         * available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is
         * returned.
         * </p>
         * 
         * @param workspaceIds
         *        The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
         *        <p>
         *        Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not
         *        immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no
         *        information is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceIds(String... workspaceIds);

        /**
         * <p>
         * The identifier of the directory. In addition, you can optionally specify a specific directory user (see
         * <code>UserName</code>). You cannot combine this parameter with any other filter.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory. In addition, you can optionally specify a specific directory user
         *        (see <code>UserName</code>). You cannot combine this parameter with any other filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.
         * </p>
         * 
         * @param userName
         *        The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot
         * combine this parameter with any other filter.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You
         *        cannot combine this parameter with any other filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The maximum number of items to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the user-decoupled WorkSpace.
         * </p>
         * 
         * @param workspaceName
         *        The name of the user-decoupled WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceName(String workspaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> workspaceIds = DefaultSdkAutoConstructList.getInstance();

        private String directoryId;

        private String userName;

        private String bundleId;

        private Integer limit;

        private String nextToken;

        private String workspaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesRequest model) {
            super(model);
            workspaceIds(model.workspaceIds);
            directoryId(model.directoryId);
            userName(model.userName);
            bundleId(model.bundleId);
            limit(model.limit);
            nextToken(model.nextToken);
            workspaceName(model.workspaceName);
        }

        public final Collection<String> getWorkspaceIds() {
            if (workspaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceIds;
        }

        public final void setWorkspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
        }

        @Override
        public final Builder workspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceIds(String... workspaceIds) {
            workspaceIds(Arrays.asList(workspaceIds));
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkspaceName() {
            return workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesRequest build() {
            return new DescribeWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
