/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesPoolsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspacesPoolsRequest.Builder, DescribeWorkspacesPoolsRequest> {
    private static final SdkField<List<String>> POOL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PoolIds")
            .getter(getter(DescribeWorkspacesPoolsRequest::poolIds))
            .setter(setter(Builder::poolIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DescribeWorkspacesPoolsFilter>> FILTERS_FIELD = SdkField
            .<List<DescribeWorkspacesPoolsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeWorkspacesPoolsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribeWorkspacesPoolsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeWorkspacesPoolsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeWorkspacesPoolsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesPoolsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_IDS_FIELD, FILTERS_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> poolIds;

    private final List<DescribeWorkspacesPoolsFilter> filters;

    private final Integer limit;

    private final String nextToken;

    private DescribeWorkspacesPoolsRequest(BuilderImpl builder) {
        super(builder);
        this.poolIds = builder.poolIds;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PoolIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPoolIds() {
        return poolIds != null && !(poolIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the WorkSpaces Pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPoolIds} method.
     * </p>
     * 
     * @return The identifier of the WorkSpaces Pools.
     */
    public final List<String> poolIds() {
        return poolIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter conditions for the WorkSpaces Pool to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filter conditions for the WorkSpaces Pool to return.
     */
    public final List<DescribeWorkspacesPoolsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return.
     * </p>
     * 
     * @return The maximum number of items to return.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolIds() ? poolIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolsRequest)) {
            return false;
        }
        DescribeWorkspacesPoolsRequest other = (DescribeWorkspacesPoolsRequest) obj;
        return hasPoolIds() == other.hasPoolIds() && Objects.equals(poolIds(), other.poolIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesPoolsRequest").add("PoolIds", hasPoolIds() ? poolIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolIds":
            return Optional.ofNullable(clazz.cast(poolIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolIds", POOL_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolsRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkspacesPoolsRequest> {
        /**
         * <p>
         * The identifier of the WorkSpaces Pools.
         * </p>
         * 
         * @param poolIds
         *        The identifier of the WorkSpaces Pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolIds(Collection<String> poolIds);

        /**
         * <p>
         * The identifier of the WorkSpaces Pools.
         * </p>
         * 
         * @param poolIds
         *        The identifier of the WorkSpaces Pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolIds(String... poolIds);

        /**
         * <p>
         * The filter conditions for the WorkSpaces Pool to return.
         * </p>
         * 
         * @param filters
         *        The filter conditions for the WorkSpaces Pool to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DescribeWorkspacesPoolsFilter> filters);

        /**
         * <p>
         * The filter conditions for the WorkSpaces Pool to return.
         * </p>
         * 
         * @param filters
         *        The filter conditions for the WorkSpaces Pool to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeWorkspacesPoolsFilter... filters);

        /**
         * <p>
         * The filter conditions for the WorkSpaces Pool to return.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<DescribeWorkspacesPoolsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<DescribeWorkspacesPoolsFilter>)
         */
        Builder filters(Consumer<DescribeWorkspacesPoolsFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of items to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> poolIds = DefaultSdkAutoConstructList.getInstance();

        private List<DescribeWorkspacesPoolsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolsRequest model) {
            super(model);
            poolIds(model.poolIds);
            filters(model.filters);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getPoolIds() {
            if (poolIds instanceof SdkAutoConstructList) {
                return null;
            }
            return poolIds;
        }

        public final void setPoolIds(Collection<String> poolIds) {
            this.poolIds = WorkspacesPoolIdsCopier.copy(poolIds);
        }

        @Override
        public final Builder poolIds(Collection<String> poolIds) {
            this.poolIds = WorkspacesPoolIdsCopier.copy(poolIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolIds(String... poolIds) {
            poolIds(Arrays.asList(poolIds));
            return this;
        }

        public final List<DescribeWorkspacesPoolsFilter.Builder> getFilters() {
            List<DescribeWorkspacesPoolsFilter.Builder> result = DescribeWorkspacesPoolsFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribeWorkspacesPoolsFilter.BuilderImpl> filters) {
            this.filters = DescribeWorkspacesPoolsFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribeWorkspacesPoolsFilter> filters) {
            this.filters = DescribeWorkspacesPoolsFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribeWorkspacesPoolsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribeWorkspacesPoolsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DescribeWorkspacesPoolsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesPoolsRequest build() {
            return new DescribeWorkspacesPoolsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
