/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployWorkspaceApplicationsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DeployWorkspaceApplicationsResponse.Builder, DeployWorkspaceApplicationsResponse> {
    private static final SdkField<WorkSpaceApplicationDeployment> DEPLOYMENT_FIELD = SdkField
            .<WorkSpaceApplicationDeployment> builder(MarshallingType.SDK_POJO).memberName("Deployment")
            .getter(getter(DeployWorkspaceApplicationsResponse::deployment)).setter(setter(Builder::deployment))
            .constructor(WorkSpaceApplicationDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkSpaceApplicationDeployment deployment;

    private DeployWorkspaceApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.deployment = builder.deployment;
    }

    /**
     * <p>
     * The list of deployed associations and information about them.
     * </p>
     * 
     * @return The list of deployed associations and information about them.
     */
    public final WorkSpaceApplicationDeployment deployment() {
        return deployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployWorkspaceApplicationsResponse)) {
            return false;
        }
        DeployWorkspaceApplicationsResponse other = (DeployWorkspaceApplicationsResponse) obj;
        return Objects.equals(deployment(), other.deployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployWorkspaceApplicationsResponse").add("Deployment", deployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deployment":
            return Optional.ofNullable(clazz.cast(deployment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Deployment", DEPLOYMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeployWorkspaceApplicationsResponse, T> g) {
        return obj -> g.apply((DeployWorkspaceApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeployWorkspaceApplicationsResponse> {
        /**
         * <p>
         * The list of deployed associations and information about them.
         * </p>
         * 
         * @param deployment
         *        The list of deployed associations and information about them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployment(WorkSpaceApplicationDeployment deployment);

        /**
         * <p>
         * The list of deployed associations and information about them.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkSpaceApplicationDeployment.Builder}
         * avoiding the need to create one manually via {@link WorkSpaceApplicationDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkSpaceApplicationDeployment.Builder#build()} is called
         * immediately and its result is passed to {@link #deployment(WorkSpaceApplicationDeployment)}.
         * 
         * @param deployment
         *        a consumer that will call methods on {@link WorkSpaceApplicationDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployment(WorkSpaceApplicationDeployment)
         */
        default Builder deployment(Consumer<WorkSpaceApplicationDeployment.Builder> deployment) {
            return deployment(WorkSpaceApplicationDeployment.builder().applyMutation(deployment).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private WorkSpaceApplicationDeployment deployment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployWorkspaceApplicationsResponse model) {
            super(model);
            deployment(model.deployment);
        }

        public final WorkSpaceApplicationDeployment.Builder getDeployment() {
            return deployment != null ? deployment.toBuilder() : null;
        }

        public final void setDeployment(WorkSpaceApplicationDeployment.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        @Override
        public final Builder deployment(WorkSpaceApplicationDeployment deployment) {
            this.deployment = deployment;
            return this;
        }

        @Override
        public DeployWorkspaceApplicationsResponse build() {
            return new DeployWorkspaceApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
