/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspacesPoolRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateWorkspacesPoolRequest.Builder, CreateWorkspacesPoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(CreateWorkspacesPoolRequest::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkspacesPoolRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(CreateWorkspacesPoolRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateWorkspacesPoolRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.<Capacity> builder(MarshallingType.SDK_POJO)
            .memberName("Capacity").getter(getter(CreateWorkspacesPoolRequest::capacity)).setter(setter(Builder::capacity))
            .constructor(Capacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWorkspacesPoolRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationSettingsRequest> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettingsRequest> builder(MarshallingType.SDK_POJO).memberName("ApplicationSettings")
            .getter(getter(CreateWorkspacesPoolRequest::applicationSettings)).setter(setter(Builder::applicationSettings))
            .constructor(ApplicationSettingsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField
            .<TimeoutSettings> builder(MarshallingType.SDK_POJO).memberName("TimeoutSettings")
            .getter(getter(CreateWorkspacesPoolRequest::timeoutSettings)).setter(setter(Builder::timeoutSettings))
            .constructor(TimeoutSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()).build();

    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunningMode").getter(getter(CreateWorkspacesPoolRequest::runningModeAsString))
            .setter(setter(Builder::runningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            DESCRIPTION_FIELD, BUNDLE_ID_FIELD, DIRECTORY_ID_FIELD, CAPACITY_FIELD, TAGS_FIELD, APPLICATION_SETTINGS_FIELD,
            TIMEOUT_SETTINGS_FIELD, RUNNING_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolName;

    private final String description;

    private final String bundleId;

    private final String directoryId;

    private final Capacity capacity;

    private final List<Tag> tags;

    private final ApplicationSettingsRequest applicationSettings;

    private final TimeoutSettings timeoutSettings;

    private final String runningMode;

    private CreateWorkspacesPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.description = builder.description;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.capacity = builder.capacity;
        this.tags = builder.tags;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
        this.runningMode = builder.runningMode;
    }

    /**
     * <p>
     * The name of the pool.
     * </p>
     * 
     * @return The name of the pool.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The pool description.
     * </p>
     * 
     * @return The pool description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the bundle for the pool.
     * </p>
     * 
     * @return The identifier of the bundle for the pool.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The identifier of the directory for the pool.
     * </p>
     * 
     * @return The identifier of the directory for the pool.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The user capacity of the pool.
     * </p>
     * 
     * @return The user capacity of the pool.
     */
    public final Capacity capacity() {
        return capacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the pool.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates the application settings of the pool.
     * </p>
     * 
     * @return Indicates the application settings of the pool.
     */
    public final ApplicationSettingsRequest applicationSettings() {
        return applicationSettings;
    }

    /**
     * <p>
     * Indicates the timeout settings of the pool.
     * </p>
     * 
     * @return Indicates the timeout settings of the pool.
     */
    public final TimeoutSettings timeoutSettings() {
        return timeoutSettings;
    }

    /**
     * <p>
     * The running mode for the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode for the pool.
     * @see PoolsRunningMode
     */
    public final PoolsRunningMode runningMode() {
        return PoolsRunningMode.fromValue(runningMode);
    }

    /**
     * <p>
     * The running mode for the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode for the pool.
     * @see PoolsRunningMode
     */
    public final String runningModeAsString() {
        return runningMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(runningModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesPoolRequest)) {
            return false;
        }
        CreateWorkspacesPoolRequest other = (CreateWorkspacesPoolRequest) obj;
        return Objects.equals(poolName(), other.poolName()) && Objects.equals(description(), other.description())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(capacity(), other.capacity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(applicationSettings(), other.applicationSettings())
                && Objects.equals(timeoutSettings(), other.timeoutSettings())
                && Objects.equals(runningModeAsString(), other.runningModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspacesPoolRequest").add("PoolName", poolName()).add("Description", description())
                .add("BundleId", bundleId()).add("DirectoryId", directoryId()).add("Capacity", capacity())
                .add("Tags", hasTags() ? tags() : null).add("ApplicationSettings", applicationSettings())
                .add("TimeoutSettings", timeoutSettings()).add("RunningMode", runningModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "TimeoutSettings":
            return Optional.ofNullable(clazz.cast(timeoutSettings()));
        case "RunningMode":
            return Optional.ofNullable(clazz.cast(runningModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ApplicationSettings", APPLICATION_SETTINGS_FIELD);
        map.put("TimeoutSettings", TIMEOUT_SETTINGS_FIELD);
        map.put("RunningMode", RUNNING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesPoolRequest, T> g) {
        return obj -> g.apply((CreateWorkspacesPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspacesPoolRequest> {
        /**
         * <p>
         * The name of the pool.
         * </p>
         * 
         * @param poolName
         *        The name of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The pool description.
         * </p>
         * 
         * @param description
         *        The pool description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the bundle for the pool.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The identifier of the directory for the pool.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The user capacity of the pool.
         * </p>
         * 
         * @param capacity
         *        The user capacity of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Capacity capacity);

        /**
         * <p>
         * The user capacity of the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capacity.Builder} avoiding the need to
         * create one manually via {@link Capacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capacity.Builder#build()} is called immediately and its result is
         * passed to {@link #capacity(Capacity)}.
         * 
         * @param capacity
         *        a consumer that will call methods on {@link Capacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacity(Capacity)
         */
        default Builder capacity(Consumer<Capacity.Builder> capacity) {
            return capacity(Capacity.builder().applyMutation(capacity).build());
        }

        /**
         * <p>
         * The tags for the pool.
         * </p>
         * 
         * @param tags
         *        The tags for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the pool.
         * </p>
         * 
         * @param tags
         *        The tags for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates the application settings of the pool.
         * </p>
         * 
         * @param applicationSettings
         *        Indicates the application settings of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettingsRequest applicationSettings);

        /**
         * <p>
         * Indicates the application settings of the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSettingsRequest.Builder}
         * avoiding the need to create one manually via {@link ApplicationSettingsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSettingsRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSettings(ApplicationSettingsRequest)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettingsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettingsRequest)
         */
        default Builder applicationSettings(Consumer<ApplicationSettingsRequest.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettingsRequest.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * Indicates the timeout settings of the pool.
         * </p>
         * 
         * @param timeoutSettings
         *        Indicates the timeout settings of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSettings(TimeoutSettings timeoutSettings);

        /**
         * <p>
         * Indicates the timeout settings of the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeoutSettings.Builder} avoiding the
         * need to create one manually via {@link TimeoutSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutSettings(TimeoutSettings)}.
         * 
         * @param timeoutSettings
         *        a consumer that will call methods on {@link TimeoutSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutSettings(TimeoutSettings)
         */
        default Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return timeoutSettings(TimeoutSettings.builder().applyMutation(timeoutSettings).build());
        }

        /**
         * <p>
         * The running mode for the pool.
         * </p>
         * 
         * @param runningMode
         *        The running mode for the pool.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(String runningMode);

        /**
         * <p>
         * The running mode for the pool.
         * </p>
         * 
         * @param runningMode
         *        The running mode for the pool.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(PoolsRunningMode runningMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String poolName;

        private String description;

        private String bundleId;

        private String directoryId;

        private Capacity capacity;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettingsRequest applicationSettings;

        private TimeoutSettings timeoutSettings;

        private String runningMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesPoolRequest model) {
            super(model);
            poolName(model.poolName);
            description(model.description);
            bundleId(model.bundleId);
            directoryId(model.directoryId);
            capacity(model.capacity);
            tags(model.tags);
            applicationSettings(model.applicationSettings);
            timeoutSettings(model.timeoutSettings);
            runningMode(model.runningMode);
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Capacity.Builder getCapacity() {
            return capacity != null ? capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettingsRequest.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsRequest.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsRequest applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return timeoutSettings != null ? timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        public final String getRunningMode() {
            return runningMode;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(PoolsRunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspacesPoolRequest build() {
            return new CreateWorkspacesPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
