/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workspaces.model.AcceptAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.AcceptAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.ApplicationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.ComputeNotCompatibleException;
import software.amazon.awssdk.services.workspaces.model.ConflictException;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.CreateAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeCustomWorkspaceImageImportRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeCustomWorkspaceImageImportResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolSessionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolSessionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.GetAccountLinkRequest;
import software.amazon.awssdk.services.workspaces.model.GetAccountLinkResponse;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.ImportCustomWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportCustomWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.IncompatibleApplicationsException;
import software.amazon.awssdk.services.workspaces.model.InternalServerException;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyEndpointEncryptionModeRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyEndpointEncryptionModeResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyStreamingPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyStreamingPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemNotCompatibleException;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.RejectAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.RejectAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceInUseException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolSessionRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolSessionResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.ValidationException;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable;
import software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable;

/**
 * Service client for accessing Amazon WorkSpaces. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon WorkSpaces Service</fullname>
 * <p>
 * Amazon WorkSpaces enables you to provision virtual, cloud-based Microsoft Windows or Amazon Linux desktops for your
 * users, known as <i>WorkSpaces</i>. WorkSpaces eliminates the need to procure and deploy hardware or install complex
 * software. You can quickly add or remove users as your needs change. Users can access their virtual desktops from
 * multiple devices or web browsers.
 * </p>
 * <p>
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the
 * WorkSpaces service. For more information about the supported Amazon Web Services Regions, endpoints, and service
 * quotas of the Amazon WorkSpaces service, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/wsp.html">WorkSpaces endpoints and quotas</a> in the <i>Amazon
 * Web Services General Reference</i>.
 * </p>
 * <p>
 * You can also manage your WorkSpaces resources using the WorkSpaces console, Command Line Interface (CLI), and SDKs.
 * For more information about administering WorkSpaces, see the <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/">Amazon WorkSpaces Administration Guide</a>. For more
 * information about using the Amazon WorkSpaces client application or web browser to access provisioned WorkSpaces, see
 * the <a href="https://docs.aws.amazon.com/workspaces/latest/userguide/">Amazon WorkSpaces User Guide</a>. For more
 * information about using the CLI to manage your WorkSpaces resources, see the <a
 * href="https://docs.aws.amazon.com/cli/latest/reference/workspaces/index.html">WorkSpaces section of the CLI
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkSpacesClient extends AwsClient {
    String SERVICE_NAME = "workspaces";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces";

    /**
     * <p>
     * Accepts the account link invitation.
     * </p>
     * <important>
     * <p>
     * There's currently no unlinking capability after you accept the account linking invitation.
     * </p>
     * </important>
     *
     * @param acceptAccountLinkInvitationRequest
     * @return Result of the AcceptAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AcceptAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AcceptAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAccountLinkInvitationResponse acceptAccountLinkInvitation(
            AcceptAccountLinkInvitationRequest acceptAccountLinkInvitationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the account link invitation.
     * </p>
     * <important>
     * <p>
     * There's currently no unlinking capability after you accept the account linking invitation.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAccountLinkInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAccountLinkInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAccountLinkInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AcceptAccountLinkInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AcceptAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AcceptAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAccountLinkInvitationResponse acceptAccountLinkInvitation(
            Consumer<AcceptAccountLinkInvitationRequest.Builder> acceptAccountLinkInvitationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return acceptAccountLinkInvitation(AcceptAccountLinkInvitationRequest.builder()
                .applyMutation(acceptAccountLinkInvitationRequest).build());
    }

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param associateConnectionAliasRequest
     * @return Result of the AssociateConnectionAlias operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectionAliasResponse associateConnectionAlias(
            AssociateConnectionAliasRequest associateConnectionAliasRequest) throws ResourceAssociatedException,
            AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateConnectionAliasRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param associateConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateConnectionAlias operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectionAliasResponse associateConnectionAlias(
            Consumer<AssociateConnectionAliasRequest.Builder> associateConnectionAliasRequest)
            throws ResourceAssociatedException, AccessDeniedException, ResourceNotFoundException,
            InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return associateConnectionAlias(AssociateConnectionAliasRequest.builder().applyMutation(associateConnectionAliasRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     *
     * @param associateIpGroupsRequest
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param associateIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateIpGroupsResponse associateIpGroups(Consumer<AssociateIpGroupsRequest.Builder> associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return associateIpGroups(AssociateIpGroupsRequest.builder().applyMutation(associateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Associates the specified application to the specified WorkSpace.
     * </p>
     *
     * @param associateWorkspaceApplicationRequest
     * @return Result of the AssociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ComputeNotCompatibleException
     *         The compute type of the WorkSpace is not compatible with the application.
     * @throws OperatingSystemNotCompatibleException
     *         The operating system of the WorkSpace is not compatible with the application.
     * @throws ApplicationNotSupportedException
     *         The specified application is not supported.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWorkspaceApplicationResponse associateWorkspaceApplication(
            AssociateWorkspaceApplicationRequest associateWorkspaceApplicationRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceAlreadyExistsException,
            ResourceInUseException, ResourceNotFoundException, ComputeNotCompatibleException,
            OperatingSystemNotCompatibleException, ApplicationNotSupportedException, IncompatibleApplicationsException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified application to the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWorkspaceApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWorkspaceApplicationRequest#builder()}
     * </p>
     *
     * @param associateWorkspaceApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ComputeNotCompatibleException
     *         The compute type of the WorkSpace is not compatible with the application.
     * @throws OperatingSystemNotCompatibleException
     *         The operating system of the WorkSpace is not compatible with the application.
     * @throws ApplicationNotSupportedException
     *         The specified application is not supported.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWorkspaceApplicationResponse associateWorkspaceApplication(
            Consumer<AssociateWorkspaceApplicationRequest.Builder> associateWorkspaceApplicationRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceAlreadyExistsException, ResourceInUseException, ResourceNotFoundException, ComputeNotCompatibleException,
            OperatingSystemNotCompatibleException, ApplicationNotSupportedException, IncompatibleApplicationsException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return associateWorkspaceApplication(AssociateWorkspaceApplicationRequest.builder()
                .applyMutation(associateWorkspaceApplicationRequest).build());
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     *
     * @param authorizeIpRulesRequest
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeIpRulesRequest.Builder} avoiding the need
     * to create one manually via {@link AuthorizeIpRulesRequest#builder()}
     * </p>
     *
     * @param authorizeIpRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest.Builder} to create a
     *        request.
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeIpRulesResponse authorizeIpRules(Consumer<AuthorizeIpRulesRequest.Builder> authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return authorizeIpRules(AuthorizeIpRulesRequest.builder().applyMutation(authorizeIpRulesRequest).build());
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important>
     *
     * @param copyWorkspaceImageRequest
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link CopyWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param copyWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyWorkspaceImageResponse copyWorkspaceImage(Consumer<CopyWorkspaceImageRequest.Builder> copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return copyWorkspaceImage(CopyWorkspaceImageRequest.builder().applyMutation(copyWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates the account link invitation.
     * </p>
     *
     * @param createAccountLinkInvitationRequest
     * @return Result of the CreateAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountLinkInvitationResponse createAccountLinkInvitation(
            CreateAccountLinkInvitationRequest createAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the account link invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountLinkInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAccountLinkInvitationRequest#builder()}
     * </p>
     *
     * @param createAccountLinkInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateAccountLinkInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountLinkInvitationResponse createAccountLinkInvitation(
            Consumer<CreateAccountLinkInvitationRequest.Builder> createAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return createAccountLinkInvitation(CreateAccountLinkInvitationRequest.builder()
                .applyMutation(createAccountLinkInvitationRequest).build());
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     *
     * @param createConnectClientAddInRequest
     * @return Result of the CreateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectClientAddInResponse createConnectClientAddIn(
            CreateConnectClientAddInRequest createConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceCreationFailedException, ResourceAlreadyExistsException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param createConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return Result of the CreateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectClientAddInResponse createConnectClientAddIn(
            Consumer<CreateConnectClientAddInRequest.Builder> createConnectClientAddInRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceCreationFailedException,
            ResourceAlreadyExistsException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createConnectClientAddIn(CreateConnectClientAddInRequest.builder().applyMutation(createConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param createConnectionAliasRequest
     * @return Result of the CreateConnectionAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionAliasResponse createConnectionAlias(CreateConnectionAliasRequest createConnectionAliasRequest)
            throws ResourceAlreadyExistsException, AccessDeniedException, InvalidParameterValuesException,
            ResourceLimitExceededException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param createConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnectionAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionAliasResponse createConnectionAlias(
            Consumer<CreateConnectionAliasRequest.Builder> createConnectionAliasRequest) throws ResourceAlreadyExistsException,
            AccessDeniedException, InvalidParameterValuesException, ResourceLimitExceededException,
            InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return createConnectionAlias(CreateConnectionAliasRequest.builder().applyMutation(createConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     *
     * @param createIpGroupRequest
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException,
            ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpGroupRequest#builder()}
     * </p>
     *
     * @param createIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest.Builder} to create a request.
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpGroupResponse createIpGroup(Consumer<CreateIpGroupRequest.Builder> createIpGroupRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException,
            ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createIpGroup(CreateIpGroupRequest.builder().applyMutation(createIpGroupRequest).build());
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     * @return Result of the CreateStandbyWorkspaces operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStandbyWorkspacesResponse createStandbyWorkspaces(CreateStandbyWorkspacesRequest createStandbyWorkspacesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStandbyWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStandbyWorkspacesRequest#builder()}
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest.Builder} to create
     *        a request.
     * @return Result of the CreateStandbyWorkspaces operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStandbyWorkspacesResponse createStandbyWorkspaces(
            Consumer<CreateStandbyWorkspacesRequest.Builder> createStandbyWorkspacesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createStandbyWorkspaces(CreateStandbyWorkspacesRequest.builder().applyMutation(createStandbyWorkspacesRequest)
                .build());
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateTagsRequest.Builder} to create a request.
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValuesException, ResourceLimitExceededException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUpdatedWorkspaceImageRequest
     * @return Result of the CreateUpdatedWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImage(
            CreateUpdatedWorkspaceImageRequest createUpdatedWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException,
            InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUpdatedWorkspaceImageRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUpdatedWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param createUpdatedWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest.Builder} to
     *        create a request.
     * @return Result of the CreateUpdatedWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImage(
            Consumer<CreateUpdatedWorkspaceImageRequest.Builder> createUpdatedWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createUpdatedWorkspaceImage(CreateUpdatedWorkspaceImageRequest.builder()
                .applyMutation(createUpdatedWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     *
     * @param createWorkspaceBundleRequest
     * @return Result of the CreateWorkspaceBundle operation returned by the service.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceBundleResponse createWorkspaceBundle(CreateWorkspaceBundleRequest createWorkspaceBundleRequest)
            throws ResourceUnavailableException, ResourceAlreadyExistsException, ResourceLimitExceededException,
            InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param createWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkspaceBundle operation returned by the service.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceBundleResponse createWorkspaceBundle(
            Consumer<CreateWorkspaceBundleRequest.Builder> createWorkspaceBundleRequest) throws ResourceUnavailableException,
            ResourceAlreadyExistsException, ResourceLimitExceededException, InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createWorkspaceBundle(CreateWorkspaceBundleRequest.builder().applyMutation(createWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     *
     * @param createWorkspaceImageRequest
     * @return Result of the CreateWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceImageResponse createWorkspaceImage(CreateWorkspaceImageRequest createWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param createWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceImageResponse createWorkspaceImage(
            Consumer<CreateWorkspaceImageRequest.Builder> createWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException,
            InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return createWorkspaceImage(CreateWorkspaceImageRequest.builder().applyMutation(createWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You don't need to specify the <code>PCOIP</code> protocol for Linux bundles because <code>DCV</code> (formerly
     * WSP) is the default protocol for those bundles.
     * </p>
     * </li>
     * <li>
     * <p>
     * User-decoupled WorkSpaces are only supported by Amazon WorkSpaces Core.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review your running mode to ensure you are using one that is optimal for your needs and budget. For more
     * information on switching running modes, see <a href=
     * "http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F"
     * > Can I switch between hourly and monthly billing?</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createWorkspacesRequest
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You don't need to specify the <code>PCOIP</code> protocol for Linux bundles because <code>DCV</code> (formerly
     * WSP) is the default protocol for those bundles.
     * </p>
     * </li>
     * <li>
     * <p>
     * User-decoupled WorkSpaces are only supported by Amazon WorkSpaces Core.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review your running mode to ensure you are using one that is optimal for your needs and budget. For more
     * information on switching running modes, see <a href=
     * "http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F"
     * > Can I switch between hourly and monthly billing?</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspacesRequest#builder()}
     * </p>
     *
     * @param createWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspacesResponse createWorkspaces(Consumer<CreateWorkspacesRequest.Builder> createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return createWorkspaces(CreateWorkspacesRequest.builder().applyMutation(createWorkspacesRequest).build());
    }

    /**
     * <p>
     * Creates a pool of WorkSpaces.
     * </p>
     *
     * @param createWorkspacesPoolRequest
     * @return Result of the CreateWorkspacesPool operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspacesPoolResponse createWorkspacesPool(CreateWorkspacesPoolRequest createWorkspacesPoolRequest)
            throws ResourceLimitExceededException, ResourceNotFoundException, InvalidParameterValuesException,
            ResourceAlreadyExistsException, OperationNotSupportedException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pool of WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspacesPoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspacesPoolRequest#builder()}
     * </p>
     *
     * @param createWorkspacesPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspacesPoolRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkspacesPool operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspacesPoolResponse createWorkspacesPool(
            Consumer<CreateWorkspacesPoolRequest.Builder> createWorkspacesPoolRequest) throws ResourceLimitExceededException,
            ResourceNotFoundException, InvalidParameterValuesException, ResourceAlreadyExistsException,
            OperationNotSupportedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createWorkspacesPool(CreateWorkspacesPoolRequest.builder().applyMutation(createWorkspacesPoolRequest).build());
    }

    /**
     * <p>
     * Deletes the account link invitation.
     * </p>
     *
     * @param deleteAccountLinkInvitationRequest
     * @return Result of the DeleteAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountLinkInvitationResponse deleteAccountLinkInvitation(
            DeleteAccountLinkInvitationRequest deleteAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the account link invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountLinkInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccountLinkInvitationRequest#builder()}
     * </p>
     *
     * @param deleteAccountLinkInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteAccountLinkInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountLinkInvitationResponse deleteAccountLinkInvitation(
            Consumer<DeleteAccountLinkInvitationRequest.Builder> deleteAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return deleteAccountLinkInvitation(DeleteAccountLinkInvitationRequest.builder()
                .applyMutation(deleteAccountLinkInvitationRequest).build());
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     *
     * @param deleteClientBrandingRequest
     * @return Result of the DeleteClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClientBrandingResponse deleteClientBranding(DeleteClientBrandingRequest deleteClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClientBrandingRequest#builder()}
     * </p>
     *
     * @param deleteClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClientBrandingResponse deleteClientBranding(
            Consumer<DeleteClientBrandingRequest.Builder> deleteClientBrandingRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteClientBranding(DeleteClientBrandingRequest.builder().applyMutation(deleteClientBrandingRequest).build());
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     * @return Result of the DeleteConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectClientAddInResponse deleteConnectClientAddIn(
            DeleteConnectClientAddInRequest deleteConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectClientAddInResponse deleteConnectClientAddIn(
            Consumer<DeleteConnectClientAddInRequest.Builder> deleteConnectClientAddInRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return deleteConnectClientAddIn(DeleteConnectClientAddInRequest.builder().applyMutation(deleteConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note>
     *
     * @param deleteConnectionAliasRequest
     * @return Result of the DeleteConnectionAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionAliasResponse deleteConnectionAlias(DeleteConnectionAliasRequest deleteConnectionAliasRequest)
            throws ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException,
            InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConnectionAliasRequest#builder()}
     * </p>
     *
     * @param deleteConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnectionAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionAliasResponse deleteConnectionAlias(
            Consumer<DeleteConnectionAliasRequest.Builder> deleteConnectionAliasRequest) throws ResourceNotFoundException,
            ResourceAssociatedException, AccessDeniedException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteConnectionAlias(DeleteConnectionAliasRequest.builder().applyMutation(deleteConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     *
     * @param deleteIpGroupRequest
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpGroupRequest#builder()}
     * </p>
     *
     * @param deleteIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest.Builder} to create a request.
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpGroupResponse deleteIpGroup(Consumer<DeleteIpGroupRequest.Builder> deleteIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteIpGroup(DeleteIpGroupRequest.builder().applyMutation(deleteIpGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     * @return Result of the DeleteWorkspaceBundle operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceBundleResponse deleteWorkspaceBundle(DeleteWorkspaceBundleRequest deleteWorkspaceBundleRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkspaceBundle operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceBundleResponse deleteWorkspaceBundle(
            Consumer<DeleteWorkspaceBundleRequest.Builder> deleteWorkspaceBundleRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return deleteWorkspaceBundle(DeleteWorkspaceBundleRequest.builder().applyMutation(deleteWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest)
            throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceImageResponse deleteWorkspaceImage(
            Consumer<DeleteWorkspaceImageRequest.Builder> deleteWorkspaceImageRequest) throws ResourceAssociatedException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteWorkspaceImage(DeleteWorkspaceImageRequest.builder().applyMutation(deleteWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Deploys associated applications to the specified WorkSpace
     * </p>
     *
     * @param deployWorkspaceApplicationsRequest
     * @return Result of the DeployWorkspaceApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeployWorkspaceApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeployWorkspaceApplicationsResponse deployWorkspaceApplications(
            DeployWorkspaceApplicationsRequest deployWorkspaceApplicationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceInUseException, ResourceNotFoundException,
            IncompatibleApplicationsException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys associated applications to the specified WorkSpace
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeployWorkspaceApplicationsRequest.Builder}
     * avoiding the need to create one manually via {@link DeployWorkspaceApplicationsRequest#builder()}
     * </p>
     *
     * @param deployWorkspaceApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest.Builder} to
     *        create a request.
     * @return Result of the DeployWorkspaceApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeployWorkspaceApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeployWorkspaceApplicationsResponse deployWorkspaceApplications(
            Consumer<DeployWorkspaceApplicationsRequest.Builder> deployWorkspaceApplicationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceInUseException, ResourceNotFoundException, IncompatibleApplicationsException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return deployWorkspaceApplications(DeployWorkspaceApplicationsRequest.builder()
                .applyMutation(deployWorkspaceApplicationsRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param deregisterWorkspaceDirectoryRequest
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWorkspaceDirectoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param deregisterWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            Consumer<DeregisterWorkspaceDirectoryRequest.Builder> deregisterWorkspaceDirectoryRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest.builder()
                .applyMutation(deregisterWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param describeAccountRequest
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAccountRequest#builder()}
     * </p>
     *
     * @param describeAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountResponse describeAccount(Consumer<DescribeAccountRequest.Builder> describeAccountRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeAccount(DescribeAccountRequest.builder().applyMutation(describeAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     *
     * @param describeAccountModificationsRequest
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountModificationsResponse describeAccountModifications(
            DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountModificationsRequest#builder()}
     * </p>
     *
     * @param describeAccountModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountModificationsResponse describeAccountModifications(
            Consumer<DescribeAccountModificationsRequest.Builder> describeAccountModificationsRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeAccountModifications(DescribeAccountModificationsRequest.builder()
                .applyMutation(describeAccountModificationsRequest).build());
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     * @return Result of the DescribeApplicationAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsResponse describeApplicationAssociations(
            DescribeApplicationAssociationsRequest describeApplicationAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationAssociationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeApplicationAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsResponse describeApplicationAssociations(
            Consumer<DescribeApplicationAssociationsRequest.Builder> describeApplicationAssociationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeApplicationAssociations(DescribeApplicationAssociationsRequest.builder()
                .applyMutation(describeApplicationAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client.describeApplicationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client
     *             .describeApplicationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client.describeApplicationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsIterable describeApplicationAssociationsPaginator(
            DescribeApplicationAssociationsRequest describeApplicationAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return new DescribeApplicationAssociationsIterable(this, describeApplicationAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client.describeApplicationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client
     *             .describeApplicationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsIterable responses = client.describeApplicationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationAssociationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsIterable describeApplicationAssociationsPaginator(
            Consumer<DescribeApplicationAssociationsRequest.Builder> describeApplicationAssociationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeApplicationAssociationsPaginator(DescribeApplicationAssociationsRequest.builder()
                .applyMutation(describeApplicationAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     *
     * @param describeApplicationsRequest
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeApplications(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client.describeApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client
     *             .describeApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client.describeApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsIterable describeApplicationsPaginator(DescribeApplicationsRequest describeApplicationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeApplicationsIterable(this, describeApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client.describeApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client
     *             .describeApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsIterable responses = client.describeApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsIterable describeApplicationsPaginator(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeApplicationsPaginator(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified bundle.
     * </p>
     *
     * @param describeBundleAssociationsRequest
     * @return Result of the DescribeBundleAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeBundleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBundleAssociationsResponse describeBundleAssociations(
            DescribeBundleAssociationsRequest describeBundleAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBundleAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBundleAssociationsRequest#builder()}
     * </p>
     *
     * @param describeBundleAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeBundleAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeBundleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBundleAssociationsResponse describeBundleAssociations(
            Consumer<DescribeBundleAssociationsRequest.Builder> describeBundleAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeBundleAssociations(DescribeBundleAssociationsRequest.builder()
                .applyMutation(describeBundleAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note>
     *
     * @param describeClientBrandingRequest
     * @return Result of the DescribeClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientBrandingResponse describeClientBranding(DescribeClientBrandingRequest describeClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClientBrandingRequest#builder()}
     * </p>
     *
     * @param describeClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientBrandingResponse describeClientBranding(
            Consumer<DescribeClientBrandingRequest.Builder> describeClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeClientBranding(DescribeClientBrandingRequest.builder().applyMutation(describeClientBrandingRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param describeClientPropertiesRequest
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientPropertiesResponse describeClientProperties(
            DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClientPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClientPropertiesRequest#builder()}
     * </p>
     *
     * @param describeClientPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientPropertiesResponse describeClientProperties(
            Consumer<DescribeClientPropertiesRequest.Builder> describeClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeClientProperties(DescribeClientPropertiesRequest.builder().applyMutation(describeClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     * @return Result of the DescribeConnectClientAddIns operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectClientAddInsResponse describeConnectClientAddIns(
            DescribeConnectClientAddInsRequest describeConnectClientAddInsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectClientAddInsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConnectClientAddInsRequest#builder()}
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConnectClientAddIns operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectClientAddInsResponse describeConnectClientAddIns(
            Consumer<DescribeConnectClientAddInsRequest.Builder> describeConnectClientAddInsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeConnectClientAddIns(DescribeConnectClientAddInsRequest.builder()
                .applyMutation(describeConnectClientAddInsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     * @return Result of the DescribeConnectionAliasPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissions(
            DescribeConnectionAliasPermissionsRequest describeConnectionAliasPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionAliasPermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConnectionAliasPermissionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeConnectionAliasPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissions(
            Consumer<DescribeConnectionAliasPermissionsRequest.Builder> describeConnectionAliasPermissionsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeConnectionAliasPermissions(DescribeConnectionAliasPermissionsRequest.builder()
                .applyMutation(describeConnectionAliasPermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasesRequest
     * @return Result of the DescribeConnectionAliases operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionAliasesResponse describeConnectionAliases(
            DescribeConnectionAliasesRequest describeConnectionAliasesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectionAliasesRequest#builder()}
     * </p>
     *
     * @param describeConnectionAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConnectionAliases operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionAliasesResponse describeConnectionAliases(
            Consumer<DescribeConnectionAliasesRequest.Builder> describeConnectionAliasesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return describeConnectionAliases(DescribeConnectionAliasesRequest.builder()
                .applyMutation(describeConnectionAliasesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a WorkSpace BYOL image being imported via ImportCustomWorkspaceImage.
     * </p>
     *
     * @param describeCustomWorkspaceImageImportRequest
     * @return Result of the DescribeCustomWorkspaceImageImport operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeCustomWorkspaceImageImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeCustomWorkspaceImageImport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomWorkspaceImageImportResponse describeCustomWorkspaceImageImport(
            DescribeCustomWorkspaceImageImportRequest describeCustomWorkspaceImageImportRequest) throws AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a WorkSpace BYOL image being imported via ImportCustomWorkspaceImage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomWorkspaceImageImportRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomWorkspaceImageImportRequest#builder()}
     * </p>
     *
     * @param describeCustomWorkspaceImageImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeCustomWorkspaceImageImportRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeCustomWorkspaceImageImport operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeCustomWorkspaceImageImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeCustomWorkspaceImageImport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomWorkspaceImageImportResponse describeCustomWorkspaceImageImport(
            Consumer<DescribeCustomWorkspaceImageImportRequest.Builder> describeCustomWorkspaceImageImportRequest)
            throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeCustomWorkspaceImageImport(DescribeCustomWorkspaceImageImportRequest.builder()
                .applyMutation(describeCustomWorkspaceImageImportRequest).build());
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified image.
     * </p>
     *
     * @param describeImageAssociationsRequest
     * @return Result of the DescribeImageAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeImageAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageAssociationsResponse describeImageAssociations(
            DescribeImageAssociationsRequest describeImageAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageAssociationsRequest#builder()}
     * </p>
     *
     * @param describeImageAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeImageAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeImageAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageAssociationsResponse describeImageAssociations(
            Consumer<DescribeImageAssociationsRequest.Builder> describeImageAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeImageAssociations(DescribeImageAssociationsRequest.builder()
                .applyMutation(describeImageAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @param describeIpGroupsRequest
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIpGroupsRequest#builder()}
     * </p>
     *
     * @param describeIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups(Consumer<DescribeIpGroupsRequest.Builder> describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return describeIpGroups(DescribeIpGroupsRequest.builder().applyMutation(describeIpGroupsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see #describeIpGroups(DescribeIpGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups() throws InvalidParameterValuesException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeIpGroups(DescribeIpGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the associations betweens applications and the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceAssociationsRequest
     * @return Result of the DescribeWorkspaceAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceAssociationsResponse describeWorkspaceAssociations(
            DescribeWorkspaceAssociationsRequest describeWorkspaceAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations betweens applications and the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspaceAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceAssociationsResponse describeWorkspaceAssociations(
            Consumer<DescribeWorkspaceAssociationsRequest.Builder> describeWorkspaceAssociationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceAssociations(DescribeWorkspaceAssociationsRequest.builder()
                .applyMutation(describeWorkspaceAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().applyMutation(describeWorkspaceBundlesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see #describeWorkspaceBundles(DescribeWorkspaceBundlesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see #describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceBundlesIterable(this, describeWorkspaceBundlesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder()
                .applyMutation(describeWorkspaceBundlesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see #describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see #describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceDirectoriesIterable(this, describeWorkspaceDirectoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     * @return Result of the DescribeWorkspaceImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissions(
            DescribeWorkspaceImagePermissionsRequest describeWorkspaceImagePermissionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceImagePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceImagePermissionsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeWorkspaceImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissions(
            Consumer<DescribeWorkspaceImagePermissionsRequest.Builder> describeWorkspaceImagePermissionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspaceImagePermissions(DescribeWorkspaceImagePermissionsRequest.builder()
                .applyMutation(describeWorkspaceImagePermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceImagesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceImagesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages(
            Consumer<DescribeWorkspaceImagesRequest.Builder> describeWorkspaceImagesRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().applyMutation(describeWorkspaceImagesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see #describeWorkspaceImages(DescribeWorkspaceImagesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages() throws AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            Consumer<DescribeWorkspaceSnapshotsRequest.Builder> describeWorkspaceSnapshotsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest.builder()
                .applyMutation(describeWorkspaceSnapshotsRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces(Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see #describeWorkspaces(DescribeWorkspacesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces() throws InvalidParameterValuesException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see #describeWorkspacesPaginator(DescribeWorkspacesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator() throws InvalidParameterValuesException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return new DescribeWorkspacesIterable(this, describeWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator(
            Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest) throws InvalidParameterValuesException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesConnectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspacesConnectionStatusRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            Consumer<DescribeWorkspacesConnectionStatusRequest.Builder> describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder()
                .applyMutation(describeWorkspacesConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see #describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus()
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified pool.
     * </p>
     *
     * @param describeWorkspacesPoolSessionsRequest
     * @return Result of the DescribeWorkspacesPoolSessions operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPoolSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPoolSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesPoolSessionsResponse describeWorkspacesPoolSessions(
            DescribeWorkspacesPoolSessionsRequest describeWorkspacesPoolSessionsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesPoolSessionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspacesPoolSessionsRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesPoolSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolSessionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspacesPoolSessions operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPoolSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPoolSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesPoolSessionsResponse describeWorkspacesPoolSessions(
            Consumer<DescribeWorkspacesPoolSessionsRequest.Builder> describeWorkspacesPoolSessionsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspacesPoolSessions(DescribeWorkspacesPoolSessionsRequest.builder()
                .applyMutation(describeWorkspacesPoolSessionsRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces Pools.
     * </p>
     *
     * @param describeWorkspacesPoolsRequest
     * @return Result of the DescribeWorkspacesPools operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesPoolsResponse describeWorkspacesPools(DescribeWorkspacesPoolsRequest describeWorkspacesPoolsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified WorkSpaces Pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesPoolsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspacesPoolsRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeWorkspacesPools operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesPoolsResponse describeWorkspacesPools(
            Consumer<DescribeWorkspacesPoolsRequest.Builder> describeWorkspacesPoolsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspacesPools(DescribeWorkspacesPoolsRequest.builder().applyMutation(describeWorkspacesPoolsRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param disassociateConnectionAliasRequest
     * @return Result of the DisassociateConnectionAlias operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectionAliasResponse disassociateConnectionAlias(
            DisassociateConnectionAliasRequest disassociateConnectionAliasRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectionAliasRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param disassociateConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateConnectionAlias operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectionAliasResponse disassociateConnectionAlias(
            Consumer<DisassociateConnectionAliasRequest.Builder> disassociateConnectionAliasRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException,
            InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return disassociateConnectionAlias(DisassociateConnectionAliasRequest.builder()
                .applyMutation(disassociateConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     *
     * @param disassociateIpGroupsRequest
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIpGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param disassociateIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpGroupsResponse disassociateIpGroups(
            Consumer<DisassociateIpGroupsRequest.Builder> disassociateIpGroupsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return disassociateIpGroups(DisassociateIpGroupsRequest.builder().applyMutation(disassociateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified application from a WorkSpace.
     * </p>
     *
     * @param disassociateWorkspaceApplicationRequest
     * @return Result of the DisassociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWorkspaceApplicationResponse disassociateWorkspaceApplication(
            DisassociateWorkspaceApplicationRequest disassociateWorkspaceApplicationRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified application from a WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWorkspaceApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWorkspaceApplicationRequest#builder()}
     * </p>
     *
     * @param disassociateWorkspaceApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWorkspaceApplicationResponse disassociateWorkspaceApplication(
            Consumer<DisassociateWorkspaceApplicationRequest.Builder> disassociateWorkspaceApplicationRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return disassociateWorkspaceApplication(DisassociateWorkspaceApplicationRequest.builder()
                .applyMutation(disassociateWorkspaceApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves account link information.
     * </p>
     *
     * @param getAccountLinkRequest
     * @return Result of the GetAccountLink operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.GetAccountLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/GetAccountLink" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountLinkResponse getAccountLink(GetAccountLinkRequest getAccountLinkRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves account link information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountLinkRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountLinkRequest#builder()}
     * </p>
     *
     * @param getAccountLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.GetAccountLinkRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountLink operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.GetAccountLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/GetAccountLink" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountLinkResponse getAccountLink(Consumer<GetAccountLinkRequest.Builder> getAccountLinkRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return getAccountLink(GetAccountLinkRequest.builder().applyMutation(getAccountLinkRequest).build());
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param importClientBrandingRequest
     * @return Result of the ImportClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportClientBrandingResponse importClientBranding(ImportClientBrandingRequest importClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link ImportClientBrandingRequest#builder()}
     * </p>
     *
     * @param importClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest.Builder} to create a
     *        request.
     * @return Result of the ImportClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportClientBrandingResponse importClientBranding(
            Consumer<ImportClientBrandingRequest.Builder> importClientBrandingRequest) throws InvalidParameterValuesException,
            ResourceLimitExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return importClientBranding(ImportClientBrandingRequest.builder().applyMutation(importClientBrandingRequest).build());
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces using EC2 Image
     * Builder. The image must be an already licensed image that is in your Amazon Web Services account, and you must
     * own the image. For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importCustomWorkspaceImageRequest
     * @return Result of the ImportCustomWorkspaceImage operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportCustomWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportCustomWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportCustomWorkspaceImageResponse importCustomWorkspaceImage(
            ImportCustomWorkspaceImageRequest importCustomWorkspaceImageRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            ResourceAlreadyExistsException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces using EC2 Image
     * Builder. The image must be an already licensed image that is in your Amazon Web Services account, and you must
     * own the image. For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCustomWorkspaceImageRequest.Builder} avoiding
     * the need to create one manually via {@link ImportCustomWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param importCustomWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ImportCustomWorkspaceImageRequest.Builder} to
     *        create a request.
     * @return Result of the ImportCustomWorkspaceImage operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportCustomWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportCustomWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportCustomWorkspaceImageResponse importCustomWorkspaceImage(
            Consumer<ImportCustomWorkspaceImageRequest.Builder> importCustomWorkspaceImageRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            ResourceAlreadyExistsException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return importCustomWorkspaceImage(ImportCustomWorkspaceImageRequest.builder()
                .applyMutation(importCustomWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importWorkspaceImageRequest
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link ImportWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param importWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportWorkspaceImageResponse importWorkspaceImage(
            Consumer<ImportWorkspaceImageRequest.Builder> importWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return importWorkspaceImage(ImportWorkspaceImageRequest.builder().applyMutation(importWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Lists all account links.
     * </p>
     *
     * @param listAccountLinksRequest
     * @return Result of the ListAccountLinks operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAccountLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAccountLinksResponse listAccountLinks(ListAccountLinksRequest listAccountLinksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account links.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountLinksRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccountLinksRequest#builder()}
     * </p>
     *
     * @param listAccountLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountLinks operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAccountLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAccountLinksResponse listAccountLinks(Consumer<ListAccountLinksRequest.Builder> listAccountLinksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return listAccountLinks(ListAccountLinksRequest.builder().applyMutation(listAccountLinksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountLinks(software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client.listAccountLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client
     *             .listAccountLinksPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client.listAccountLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountLinks(software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountLinksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAccountLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAccountLinksIterable listAccountLinksPaginator(ListAccountLinksRequest listAccountLinksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return new ListAccountLinksIterable(this, listAccountLinksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountLinks(software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client.listAccountLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client
     *             .listAccountLinksPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.ListAccountLinksIterable responses = client.listAccountLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountLinks(software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountLinksRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccountLinksRequest#builder()}
     * </p>
     *
     * @param listAccountLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAccountLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAccountLinksIterable listAccountLinksPaginator(Consumer<ListAccountLinksRequest.Builder> listAccountLinksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return listAccountLinksPaginator(ListAccountLinksRequest.builder().applyMutation(listAccountLinksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagementCidrRangesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagementCidrRangesRequest#builder()}
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest.Builder}
     *        to create a request.
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            Consumer<ListAvailableManagementCidrRangesRequest.Builder> listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest.builder()
                .applyMutation(listAvailableManagementCidrRangesRequest).build());
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     *
     * @param migrateWorkspaceRequest
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MigrateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link MigrateWorkspaceRequest#builder()}
     * </p>
     *
     * @param migrateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest.Builder} to create a
     *        request.
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default MigrateWorkspaceResponse migrateWorkspace(Consumer<MigrateWorkspaceRequest.Builder> migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return migrateWorkspace(MigrateWorkspaceRequest.builder().applyMutation(migrateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param modifyAccountRequest
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest)
            throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException,
            ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyAccountRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyAccountRequest#builder()}
     * </p>
     *
     * @param modifyAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest.Builder} to create a request.
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyAccountResponse modifyAccount(Consumer<ModifyAccountRequest.Builder> modifyAccountRequest)
            throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException,
            ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyAccount(ModifyAccountRequest.builder().applyMutation(modifyAccountRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     * @return Result of the ModifyCertificateBasedAuthProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthProperties(
            ModifyCertificateBasedAuthPropertiesRequest modifyCertificateBasedAuthPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ModifyCertificateBasedAuthPropertiesRequest.Builder} avoiding the need to create one manually via
     * {@link ModifyCertificateBasedAuthPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyCertificateBasedAuthProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthProperties(
            Consumer<ModifyCertificateBasedAuthPropertiesRequest.Builder> modifyCertificateBasedAuthPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyCertificateBasedAuthProperties(ModifyCertificateBasedAuthPropertiesRequest.builder()
                .applyMutation(modifyCertificateBasedAuthPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param modifyClientPropertiesRequest
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClientPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClientPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyClientPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClientPropertiesResponse modifyClientProperties(
            Consumer<ModifyClientPropertiesRequest.Builder> modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyClientProperties(ModifyClientPropertiesRequest.builder().applyMutation(modifyClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the endpoint encryption mode that allows you to configure the specified directory between Standard TLS
     * and FIPS 140-2 validated mode.
     * </p>
     *
     * @param modifyEndpointEncryptionModeRequest
     * @return Result of the ModifyEndpointEncryptionMode operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyEndpointEncryptionMode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyEndpointEncryptionMode"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyEndpointEncryptionModeResponse modifyEndpointEncryptionMode(
            ModifyEndpointEncryptionModeRequest modifyEndpointEncryptionModeRequest) throws AccessDeniedException,
            ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the endpoint encryption mode that allows you to configure the specified directory between Standard TLS
     * and FIPS 140-2 validated mode.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEndpointEncryptionModeRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyEndpointEncryptionModeRequest#builder()}
     * </p>
     *
     * @param modifyEndpointEncryptionModeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyEndpointEncryptionModeRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyEndpointEncryptionMode operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyEndpointEncryptionMode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyEndpointEncryptionMode"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyEndpointEncryptionModeResponse modifyEndpointEncryptionMode(
            Consumer<ModifyEndpointEncryptionModeRequest.Builder> modifyEndpointEncryptionModeRequest)
            throws AccessDeniedException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifyEndpointEncryptionMode(ModifyEndpointEncryptionModeRequest.builder()
                .applyMutation(modifyEndpointEncryptionModeRequest).build());
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     *
     * @param modifySamlPropertiesRequest
     * @return Result of the ModifySamlProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySamlPropertiesResponse modifySamlProperties(ModifySamlPropertiesRequest modifySamlPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySamlPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifySamlPropertiesRequest#builder()}
     * </p>
     *
     * @param modifySamlPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ModifySamlProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySamlPropertiesResponse modifySamlProperties(
            Consumer<ModifySamlPropertiesRequest.Builder> modifySamlPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifySamlProperties(ModifySamlPropertiesRequest.builder().applyMutation(modifySamlPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySelfservicePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ModifySelfservicePermissionsRequest#builder()}
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest.Builder} to
     *        create a request.
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            Consumer<ModifySelfservicePermissionsRequest.Builder> modifySelfservicePermissionsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifySelfservicePermissions(ModifySelfservicePermissionsRequest.builder()
                .applyMutation(modifySelfservicePermissionsRequest).build());
    }

    /**
     * <p>
     * Modifies the specified streaming properties.
     * </p>
     *
     * @param modifyStreamingPropertiesRequest
     * @return Result of the ModifyStreamingProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyStreamingProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyStreamingProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyStreamingPropertiesResponse modifyStreamingProperties(
            ModifyStreamingPropertiesRequest modifyStreamingPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified streaming properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyStreamingPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyStreamingPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyStreamingPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyStreamingPropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyStreamingProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyStreamingProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyStreamingProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyStreamingPropertiesResponse modifyStreamingProperties(
            Consumer<ModifyStreamingPropertiesRequest.Builder> modifyStreamingPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifyStreamingProperties(ModifyStreamingPropertiesRequest.builder()
                .applyMutation(modifyStreamingPropertiesRequest).build());
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidParameterCombinationException
     *         Two or more of the selected parameter values cannot be used together.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException,
            AccessDeniedException, InvalidParameterValuesException, InvalidParameterCombinationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceAccessPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceAccessPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidParameterCombinationException
     *         Two or more of the selected parameter values cannot be used together.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            Consumer<ModifyWorkspaceAccessPropertiesRequest.Builder> modifyWorkspaceAccessPropertiesRequest)
            throws ResourceNotFoundException, AccessDeniedException, InvalidParameterValuesException,
            InvalidParameterCombinationException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceAccessPropertiesRequest).build());
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceCreationPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceCreationPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            Consumer<ModifyWorkspaceCreationPropertiesRequest.Builder> modifyWorkspaceCreationPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceCreationPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param modifyWorkspacePropertiesRequest
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException,
            ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspacePropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyWorkspacePropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspacePropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            Consumer<ModifyWorkspacePropertiesRequest.Builder> modifyWorkspacePropertiesRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, OperationInProgressException,
            UnsupportedWorkspaceConfigurationException, ResourceNotFoundException, AccessDeniedException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest.builder()
                .applyMutation(modifyWorkspacePropertiesRequest).build());
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceStateRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyWorkspaceStateRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceStateResponse modifyWorkspaceState(
            Consumer<ModifyWorkspaceStateRequest.Builder> modifyWorkspaceStateRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifyWorkspaceState(ModifyWorkspaceStateRequest.builder().applyMutation(modifyWorkspaceStateRequest).build());
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code>, <code>UNHEALTHY</code>, or
     * <code>REBOOTING</code>. Reboot a WorkSpace in the <code>REBOOTING</code> state only if your WorkSpace has been
     * stuck in the <code>REBOOTING</code> state for over 20 minutes.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     *
     * @param rebootWorkspacesRequest
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code>, <code>UNHEALTHY</code>, or
     * <code>REBOOTING</code>. Reboot a WorkSpace in the <code>REBOOTING</code> state only if your WorkSpace has been
     * stuck in the <code>REBOOTING</code> state for over 20 minutes.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebootWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebootWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootWorkspacesResponse rebootWorkspaces(Consumer<RebootWorkspacesRequest.Builder> rebootWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return rebootWorkspaces(RebootWorkspacesRequest.builder().applyMutation(rebootWorkspacesRequest).build());
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     *
     * @param rebuildWorkspacesRequest
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebuildWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebuildWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebuildWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebuildWorkspacesResponse rebuildWorkspaces(Consumer<RebuildWorkspacesRequest.Builder> rebuildWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return rebuildWorkspaces(RebuildWorkspacesRequest.builder().applyMutation(rebuildWorkspacesRequest).build());
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException,
            WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException,
            OperationNotSupportedException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterWorkspaceDirectoryRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            Consumer<RegisterWorkspaceDirectoryRequest.Builder> registerWorkspaceDirectoryRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            AccessDeniedException, WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException,
            UnsupportedNetworkConfigurationException, OperationNotSupportedException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest.builder()
                .applyMutation(registerWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Rejects the account link invitation.
     * </p>
     *
     * @param rejectAccountLinkInvitationRequest
     * @return Result of the RejectAccountLinkInvitation operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RejectAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RejectAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectAccountLinkInvitationResponse rejectAccountLinkInvitation(
            RejectAccountLinkInvitationRequest rejectAccountLinkInvitationRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the account link invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectAccountLinkInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link RejectAccountLinkInvitationRequest#builder()}
     * </p>
     *
     * @param rejectAccountLinkInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RejectAccountLinkInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the RejectAccountLinkInvitation operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RejectAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RejectAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectAccountLinkInvitationResponse rejectAccountLinkInvitation(
            Consumer<RejectAccountLinkInvitationRequest.Builder> rejectAccountLinkInvitationRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, WorkSpacesException {
        return rejectAccountLinkInvitation(RejectAccountLinkInvitationRequest.builder()
                .applyMutation(rejectAccountLinkInvitationRequest).build());
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     *
     * @param restoreWorkspaceRequest
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link RestoreWorkspaceRequest#builder()}
     * </p>
     *
     * @param restoreWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest.Builder} to create a
     *        request.
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreWorkspaceResponse restoreWorkspace(Consumer<RestoreWorkspaceRequest.Builder> restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return restoreWorkspace(RestoreWorkspaceRequest.builder().applyMutation(restoreWorkspaceRequest).build());
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     *
     * @param revokeIpRulesRequest
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeIpRulesRequest.Builder} avoiding the need to
     * create one manually via {@link RevokeIpRulesRequest#builder()}
     * </p>
     *
     * @param revokeIpRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest.Builder} to create a request.
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeIpRulesResponse revokeIpRules(Consumer<RevokeIpRulesRequest.Builder> revokeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return revokeIpRules(RevokeIpRulesRequest.builder().applyMutation(revokeIpRulesRequest).build());
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>STOPPED</code>.
     * </p>
     *
     * @param startWorkspacesRequest
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link StartWorkspacesRequest#builder()}
     * </p>
     *
     * @param startWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default StartWorkspacesResponse startWorkspaces(Consumer<StartWorkspacesRequest.Builder> startWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return startWorkspaces(StartWorkspacesRequest.builder().applyMutation(startWorkspacesRequest).build());
    }

    /**
     * <p>
     * Starts the specified pool.
     * </p>
     * <p>
     * You cannot start a pool unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>
     * .
     * </p>
     *
     * @param startWorkspacesPoolRequest
     * @return Result of the StartWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWorkspacesPoolResponse startWorkspacesPool(StartWorkspacesPoolRequest startWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceLimitExceededException,
            ResourceNotFoundException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified pool.
     * </p>
     * <p>
     * You cannot start a pool unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkspacesPoolRequest.Builder} avoiding the
     * need to create one manually via {@link StartWorkspacesPoolRequest#builder()}
     * </p>
     *
     * @param startWorkspacesPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StartWorkspacesPoolRequest.Builder} to create a
     *        request.
     * @return Result of the StartWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWorkspacesPoolResponse startWorkspacesPool(
            Consumer<StartWorkspacesPoolRequest.Builder> startWorkspacesPoolRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, ResourceLimitExceededException, ResourceNotFoundException,
            OperationNotSupportedException, OperationInProgressException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return startWorkspacesPool(StartWorkspacesPoolRequest.builder().applyMutation(startWorkspacesPoolRequest).build());
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesRequest
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link StopWorkspacesRequest#builder()}
     * </p>
     *
     * @param stopWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkspacesResponse stopWorkspaces(Consumer<StopWorkspacesRequest.Builder> stopWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return stopWorkspaces(StopWorkspacesRequest.builder().applyMutation(stopWorkspacesRequest).build());
    }

    /**
     * <p>
     * Stops the specified pool.
     * </p>
     * <p>
     * You cannot stop a WorkSpace pool unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesPoolRequest
     * @return Result of the StopWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesPool" target="_top">AWS
     *      API Documentation</a>
     */
    default StopWorkspacesPoolResponse stopWorkspacesPool(StopWorkspacesPoolRequest stopWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified pool.
     * </p>
     * <p>
     * You cannot stop a WorkSpace pool unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkspacesPoolRequest.Builder} avoiding the
     * need to create one manually via {@link StopWorkspacesPoolRequest#builder()}
     * </p>
     *
     * @param stopWorkspacesPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StopWorkspacesPoolRequest.Builder} to create a
     *        request.
     * @return Result of the StopWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesPool" target="_top">AWS
     *      API Documentation</a>
     */
    default StopWorkspacesPoolResponse stopWorkspacesPool(Consumer<StopWorkspacesPoolRequest.Builder> stopWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return stopWorkspacesPool(StopWorkspacesPoolRequest.builder().applyMutation(stopWorkspacesPoolRequest).build());
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web ServicesSupport before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param terminateWorkspacesRequest
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web ServicesSupport before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateWorkspacesRequest#builder()}
     * </p>
     *
     * @param terminateWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesResponse terminateWorkspaces(
            Consumer<TerminateWorkspacesRequest.Builder> terminateWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        return terminateWorkspaces(TerminateWorkspacesRequest.builder().applyMutation(terminateWorkspacesRequest).build());
    }

    /**
     * <p>
     * Terminates the specified pool.
     * </p>
     *
     * @param terminateWorkspacesPoolRequest
     * @return Result of the TerminateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesPoolResponse terminateWorkspacesPool(TerminateWorkspacesPoolRequest terminateWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkspacesPoolRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateWorkspacesPoolRequest#builder()}
     * </p>
     *
     * @param terminateWorkspacesPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolRequest.Builder} to create
     *        a request.
     * @return Result of the TerminateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesPoolResponse terminateWorkspacesPool(
            Consumer<TerminateWorkspacesPoolRequest.Builder> terminateWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return terminateWorkspacesPool(TerminateWorkspacesPoolRequest.builder().applyMutation(terminateWorkspacesPoolRequest)
                .build());
    }

    /**
     * <p>
     * Terminates the pool session.
     * </p>
     *
     * @param terminateWorkspacesPoolSessionRequest
     * @return Result of the TerminateWorkspacesPoolSession operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPoolSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPoolSession"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesPoolSessionResponse terminateWorkspacesPoolSession(
            TerminateWorkspacesPoolSessionRequest terminateWorkspacesPoolSessionRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the pool session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkspacesPoolSessionRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateWorkspacesPoolSessionRequest#builder()}
     * </p>
     *
     * @param terminateWorkspacesPoolSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolSessionRequest.Builder} to
     *        create a request.
     * @return Result of the TerminateWorkspacesPoolSession operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPoolSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPoolSession"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateWorkspacesPoolSessionResponse terminateWorkspacesPoolSession(
            Consumer<TerminateWorkspacesPoolSessionRequest.Builder> terminateWorkspacesPoolSessionRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return terminateWorkspacesPoolSession(TerminateWorkspacesPoolSessionRequest.builder()
                .applyMutation(terminateWorkspacesPoolSessionRequest).build());
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     *
     * @param updateConnectClientAddInRequest
     * @return Result of the UpdateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectClientAddInResponse updateConnectClientAddIn(
            UpdateConnectClientAddInRequest updateConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param updateConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectClientAddInResponse updateConnectClientAddIn(
            Consumer<UpdateConnectClientAddInRequest.Builder> updateConnectClientAddInRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return updateConnectClientAddIn(UpdateConnectClientAddInRequest.builder().applyMutation(updateConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateConnectionAliasPermissionRequest
     * @return Result of the UpdateConnectionAliasPermission operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionAliasPermissionResponse updateConnectionAliasPermission(
            UpdateConnectionAliasPermissionRequest updateConnectionAliasPermissionRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceAssociatedException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionAliasPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConnectionAliasPermissionRequest#builder()}
     * </p>
     *
     * @param updateConnectionAliasPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateConnectionAliasPermission operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionAliasPermissionResponse updateConnectionAliasPermission(
            Consumer<UpdateConnectionAliasPermissionRequest.Builder> updateConnectionAliasPermissionRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceLimitExceededException,
            ResourceNotFoundException, ResourceAssociatedException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return updateConnectionAliasPermission(UpdateConnectionAliasPermissionRequest.builder()
                .applyMutation(updateConnectionAliasPermissionRequest).build());
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRulesOfIpGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRulesOfIpGroupRequest#builder()}
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(
            Consumer<UpdateRulesOfIpGroupRequest.Builder> updateRulesOfIpGroupRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest.builder().applyMutation(updateRulesOfIpGroupRequest).build());
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important>
     *
     * @param updateWorkspaceBundleRequest
     * @return Result of the UpdateWorkspaceBundle operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceBundleResponse updateWorkspaceBundle(UpdateWorkspaceBundleRequest updateWorkspaceBundleRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkspaceBundle operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceBundleResponse updateWorkspaceBundle(
            Consumer<UpdateWorkspaceBundleRequest.Builder> updateWorkspaceBundleRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, ResourceUnavailableException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return updateWorkspaceBundle(UpdateWorkspaceBundleRequest.builder().applyMutation(updateWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web ServicesSupport.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateWorkspaceImagePermissionRequest
     * @return Result of the UpdateWorkspaceImagePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermission(
            UpdateWorkspaceImagePermissionRequest updateWorkspaceImagePermissionRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web ServicesSupport.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceImagePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWorkspaceImagePermissionRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceImagePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateWorkspaceImagePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermission(
            Consumer<UpdateWorkspaceImagePermissionRequest.Builder> updateWorkspaceImagePermissionRequest)
            throws ResourceNotFoundException, ResourceUnavailableException, AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return updateWorkspaceImagePermission(UpdateWorkspaceImagePermissionRequest.builder()
                .applyMutation(updateWorkspaceImagePermissionRequest).build());
    }

    /**
     * <p>
     * Updates the specified pool.
     * </p>
     *
     * @param updateWorkspacesPoolRequest
     * @return Result of the UpdateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspacesPoolResponse updateWorkspacesPool(UpdateWorkspacesPoolRequest updateWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            ResourceLimitExceededException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspacesPoolRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkspacesPoolRequest#builder()}
     * </p>
     *
     * @param updateWorkspacesPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateWorkspacesPoolRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspacesPoolResponse updateWorkspacesPool(
            Consumer<UpdateWorkspacesPoolRequest.Builder> updateWorkspacesPoolRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, ResourceNotFoundException, ResourceLimitExceededException,
            OperationNotSupportedException, OperationInProgressException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return updateWorkspacesPool(UpdateWorkspacesPoolRequest.builder().applyMutation(updateWorkspacesPoolRequest).build());
    }

    /**
     * Create a {@link WorkSpacesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkSpacesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkSpacesClient}.
     */
    static WorkSpacesClientBuilder builder() {
        return new DefaultWorkSpacesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default WorkSpacesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
