/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.CustomImageProtocol;
import software.amazon.awssdk.services.workspaces.model.ImageComputeType;
import software.amazon.awssdk.services.workspaces.model.ImageSourceIdentifier;
import software.amazon.awssdk.services.workspaces.model.OSVersion;
import software.amazon.awssdk.services.workspaces.model.Platform;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportCustomWorkspaceImageRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ImportCustomWorkspaceImageRequest> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::imageName)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDescription").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::imageDescription)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::imageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDescription").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeType").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::computeTypeAsString)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::protocolAsString)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<ImageSourceIdentifier> IMAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageSource").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::imageSource)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::imageSource)).constructor(ImageSourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSource").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InfrastructureConfigurationArn").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::infrastructureConfigurationArn)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfigurationArn").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::platformAsString)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsVersion").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::osVersionAsString)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportCustomWorkspaceImageRequest.getter(ImportCustomWorkspaceImageRequest::tags)).setter(ImportCustomWorkspaceImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD, IMAGE_DESCRIPTION_FIELD, COMPUTE_TYPE_FIELD, PROTOCOL_FIELD, IMAGE_SOURCE_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportCustomWorkspaceImageRequest.memberNameToFieldInitializer();
    private final String imageName;
    private final String imageDescription;
    private final String computeType;
    private final String protocol;
    private final ImageSourceIdentifier imageSource;
    private final String infrastructureConfigurationArn;
    private final String platform;
    private final String osVersion;
    private final List<Tag> tags;

    private ImportCustomWorkspaceImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.imageDescription = builder.imageDescription;
        this.computeType = builder.computeType;
        this.protocol = builder.protocol;
        this.imageSource = builder.imageSource;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.tags = builder.tags;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String imageDescription() {
        return this.imageDescription;
    }

    public final ImageComputeType computeType() {
        return ImageComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final CustomImageProtocol protocol() {
        return CustomImageProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final ImageSourceIdentifier imageSource() {
        return this.imageSource;
    }

    public final String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final OSVersion osVersion() {
        return OSVersion.fromValue(this.osVersion);
    }

    public final String osVersionAsString() {
        return this.osVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCustomWorkspaceImageRequest)) {
            return false;
        }
        ImportCustomWorkspaceImageRequest other = (ImportCustomWorkspaceImageRequest)((Object)obj);
        return Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageDescription(), other.imageDescription()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.imageSource(), other.imageSource()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.osVersionAsString(), other.osVersionAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImportCustomWorkspaceImageRequest").add("ImageName", (Object)this.imageName()).add("ImageDescription", (Object)this.imageDescription()).add("ComputeType", (Object)this.computeTypeAsString()).add("Protocol", (Object)this.protocolAsString()).add("ImageSource", (Object)this.imageSource()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).add("Platform", (Object)this.platformAsString()).add("OsVersion", (Object)this.osVersionAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageDescription": {
                return Optional.ofNullable(clazz.cast(this.imageDescription()));
            }
            case "ComputeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "ImageSource": {
                return Optional.ofNullable(clazz.cast(this.imageSource()));
            }
            case "InfrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "OsVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersionAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("ImageDescription", IMAGE_DESCRIPTION_FIELD);
        map.put("ComputeType", COMPUTE_TYPE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("ImageSource", IMAGE_SOURCE_FIELD);
        map.put("InfrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("OsVersion", OS_VERSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportCustomWorkspaceImageRequest, T> g) {
        return obj -> g.apply((ImportCustomWorkspaceImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String imageName;
        private String imageDescription;
        private String computeType;
        private String protocol;
        private ImageSourceIdentifier imageSource;
        private String infrastructureConfigurationArn;
        private String platform;
        private String osVersion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCustomWorkspaceImageRequest model) {
            super(model);
            this.imageName(model.imageName);
            this.imageDescription(model.imageDescription);
            this.computeType(model.computeType);
            this.protocol(model.protocol);
            this.imageSource(model.imageSource);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            this.platform(model.platform);
            this.osVersion(model.osVersion);
            this.tags(model.tags);
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageDescription() {
            return this.imageDescription;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ImageComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(CustomImageProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final ImageSourceIdentifier.Builder getImageSource() {
            return this.imageSource != null ? this.imageSource.toBuilder() : null;
        }

        public final void setImageSource(ImageSourceIdentifier.BuilderImpl imageSource) {
            this.imageSource = imageSource != null ? imageSource.build() : null;
        }

        @Override
        public final Builder imageSource(ImageSourceIdentifier imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public final Builder osVersion(OSVersion osVersion) {
            this.osVersion(osVersion == null ? null : osVersion.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCustomWorkspaceImageRequest build() {
            return new ImportCustomWorkspaceImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportCustomWorkspaceImageRequest> {
        public Builder imageName(String var1);

        public Builder imageDescription(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ImageComputeType var1);

        public Builder protocol(String var1);

        public Builder protocol(CustomImageProtocol var1);

        public Builder imageSource(ImageSourceIdentifier var1);

        default public Builder imageSource(Consumer<ImageSourceIdentifier.Builder> imageSource) {
            return this.imageSource((ImageSourceIdentifier)((ImageSourceIdentifier.Builder)ImageSourceIdentifier.builder().applyMutation(imageSource)).build());
        }

        public Builder infrastructureConfigurationArn(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder osVersion(String var1);

        public Builder osVersion(OSVersion var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

