/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSourceIdentifier> {
    private static final SdkField<String> EC2_IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2ImportTaskId").getter(ImageSourceIdentifier.getter(ImageSourceIdentifier::ec2ImportTaskId)).setter(ImageSourceIdentifier.setter(Builder::ec2ImportTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImportTaskId").build()}).build();
    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuildVersionArn").getter(ImageSourceIdentifier.getter(ImageSourceIdentifier::imageBuildVersionArn)).setter(ImageSourceIdentifier.setter(Builder::imageBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuildVersionArn").build()}).build();
    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2ImageId").getter(ImageSourceIdentifier.getter(ImageSourceIdentifier::ec2ImageId)).setter(ImageSourceIdentifier.setter(Builder::ec2ImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_IMPORT_TASK_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, EC2_IMAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageSourceIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ec2ImportTaskId;
    private final String imageBuildVersionArn;
    private final String ec2ImageId;
    private final Type type;

    private ImageSourceIdentifier(BuilderImpl builder) {
        this.ec2ImportTaskId = builder.ec2ImportTaskId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.ec2ImageId = builder.ec2ImageId;
        this.type = builder.type;
    }

    public final String ec2ImportTaskId() {
        return this.ec2ImportTaskId;
    }

    public final String imageBuildVersionArn() {
        return this.imageBuildVersionArn;
    }

    public final String ec2ImageId() {
        return this.ec2ImageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ImportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ImageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSourceIdentifier)) {
            return false;
        }
        ImageSourceIdentifier other = (ImageSourceIdentifier)obj;
        return Objects.equals(this.ec2ImportTaskId(), other.ec2ImportTaskId()) && Objects.equals(this.imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(this.ec2ImageId(), other.ec2ImageId());
    }

    public final String toString() {
        return ToString.builder((String)"ImageSourceIdentifier").add("Ec2ImportTaskId", (Object)this.ec2ImportTaskId()).add("ImageBuildVersionArn", (Object)this.imageBuildVersionArn()).add("Ec2ImageId", (Object)this.ec2ImageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2ImportTaskId": {
                return Optional.ofNullable(clazz.cast(this.ec2ImportTaskId()));
            }
            case "ImageBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageBuildVersionArn()));
            }
            case "Ec2ImageId": {
                return Optional.ofNullable(clazz.cast(this.ec2ImageId()));
            }
        }
        return Optional.empty();
    }

    public static ImageSourceIdentifier fromEc2ImportTaskId(String ec2ImportTaskId) {
        return (ImageSourceIdentifier)ImageSourceIdentifier.builder().ec2ImportTaskId(ec2ImportTaskId).build();
    }

    public static ImageSourceIdentifier fromImageBuildVersionArn(String imageBuildVersionArn) {
        return (ImageSourceIdentifier)ImageSourceIdentifier.builder().imageBuildVersionArn(imageBuildVersionArn).build();
    }

    public static ImageSourceIdentifier fromEc2ImageId(String ec2ImageId) {
        return (ImageSourceIdentifier)ImageSourceIdentifier.builder().ec2ImageId(ec2ImageId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Ec2ImportTaskId", EC2_IMPORT_TASK_ID_FIELD);
        map.put("ImageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("Ec2ImageId", EC2_IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSourceIdentifier, T> g) {
        return obj -> g.apply((ImageSourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EC2_IMPORT_TASK_ID,
        IMAGE_BUILD_VERSION_ARN,
        EC2_IMAGE_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String ec2ImportTaskId;
        private String imageBuildVersionArn;
        private String ec2ImageId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSourceIdentifier model) {
            this.ec2ImportTaskId(model.ec2ImportTaskId);
            this.imageBuildVersionArn(model.imageBuildVersionArn);
            this.ec2ImageId(model.ec2ImageId);
        }

        public final String getEc2ImportTaskId() {
            return this.ec2ImportTaskId;
        }

        public final void setEc2ImportTaskId(String ec2ImportTaskId) {
            String oldValue = this.ec2ImportTaskId;
            this.ec2ImportTaskId = ec2ImportTaskId;
            this.handleUnionValueChange(Type.EC2_IMPORT_TASK_ID, oldValue, this.ec2ImportTaskId);
        }

        @Override
        public final Builder ec2ImportTaskId(String ec2ImportTaskId) {
            String oldValue = this.ec2ImportTaskId;
            this.ec2ImportTaskId = ec2ImportTaskId;
            this.handleUnionValueChange(Type.EC2_IMPORT_TASK_ID, oldValue, this.ec2ImportTaskId);
            return this;
        }

        public final String getImageBuildVersionArn() {
            return this.imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            String oldValue = this.imageBuildVersionArn;
            this.imageBuildVersionArn = imageBuildVersionArn;
            this.handleUnionValueChange(Type.IMAGE_BUILD_VERSION_ARN, oldValue, this.imageBuildVersionArn);
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            String oldValue = this.imageBuildVersionArn;
            this.imageBuildVersionArn = imageBuildVersionArn;
            this.handleUnionValueChange(Type.IMAGE_BUILD_VERSION_ARN, oldValue, this.imageBuildVersionArn);
            return this;
        }

        public final String getEc2ImageId() {
            return this.ec2ImageId;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            String oldValue = this.ec2ImageId;
            this.ec2ImageId = ec2ImageId;
            this.handleUnionValueChange(Type.EC2_IMAGE_ID, oldValue, this.ec2ImageId);
        }

        @Override
        public final Builder ec2ImageId(String ec2ImageId) {
            String oldValue = this.ec2ImageId;
            this.ec2ImageId = ec2ImageId;
            this.handleUnionValueChange(Type.EC2_IMAGE_ID, oldValue, this.ec2ImageId);
            return this;
        }

        public ImageSourceIdentifier build() {
            return new ImageSourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSourceIdentifier> {
        public Builder ec2ImportTaskId(String var1);

        public Builder imageBuildVersionArn(String var1);

        public Builder ec2ImageId(String var1);
    }
}

