/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ReconnectEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfservicePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfservicePermissions> {
    private static final SdkField<String> RESTART_WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestartWorkspace").getter(SelfservicePermissions.getter(SelfservicePermissions::restartWorkspaceAsString)).setter(SelfservicePermissions.setter(Builder::restartWorkspace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestartWorkspace").build()}).build();
    private static final SdkField<String> INCREASE_VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncreaseVolumeSize").getter(SelfservicePermissions.getter(SelfservicePermissions::increaseVolumeSizeAsString)).setter(SelfservicePermissions.setter(Builder::increaseVolumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncreaseVolumeSize").build()}).build();
    private static final SdkField<String> CHANGE_COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeComputeType").getter(SelfservicePermissions.getter(SelfservicePermissions::changeComputeTypeAsString)).setter(SelfservicePermissions.setter(Builder::changeComputeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeComputeType").build()}).build();
    private static final SdkField<String> SWITCH_RUNNING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SwitchRunningMode").getter(SelfservicePermissions.getter(SelfservicePermissions::switchRunningModeAsString)).setter(SelfservicePermissions.setter(Builder::switchRunningMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SwitchRunningMode").build()}).build();
    private static final SdkField<String> REBUILD_WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RebuildWorkspace").getter(SelfservicePermissions.getter(SelfservicePermissions::rebuildWorkspaceAsString)).setter(SelfservicePermissions.setter(Builder::rebuildWorkspace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTART_WORKSPACE_FIELD, INCREASE_VOLUME_SIZE_FIELD, CHANGE_COMPUTE_TYPE_FIELD, SWITCH_RUNNING_MODE_FIELD, REBUILD_WORKSPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RestartWorkspace", RESTART_WORKSPACE_FIELD);
            this.put("IncreaseVolumeSize", INCREASE_VOLUME_SIZE_FIELD);
            this.put("ChangeComputeType", CHANGE_COMPUTE_TYPE_FIELD);
            this.put("SwitchRunningMode", SWITCH_RUNNING_MODE_FIELD);
            this.put("RebuildWorkspace", REBUILD_WORKSPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String restartWorkspace;
    private final String increaseVolumeSize;
    private final String changeComputeType;
    private final String switchRunningMode;
    private final String rebuildWorkspace;

    private SelfservicePermissions(BuilderImpl builder) {
        this.restartWorkspace = builder.restartWorkspace;
        this.increaseVolumeSize = builder.increaseVolumeSize;
        this.changeComputeType = builder.changeComputeType;
        this.switchRunningMode = builder.switchRunningMode;
        this.rebuildWorkspace = builder.rebuildWorkspace;
    }

    public final ReconnectEnum restartWorkspace() {
        return ReconnectEnum.fromValue(this.restartWorkspace);
    }

    public final String restartWorkspaceAsString() {
        return this.restartWorkspace;
    }

    public final ReconnectEnum increaseVolumeSize() {
        return ReconnectEnum.fromValue(this.increaseVolumeSize);
    }

    public final String increaseVolumeSizeAsString() {
        return this.increaseVolumeSize;
    }

    public final ReconnectEnum changeComputeType() {
        return ReconnectEnum.fromValue(this.changeComputeType);
    }

    public final String changeComputeTypeAsString() {
        return this.changeComputeType;
    }

    public final ReconnectEnum switchRunningMode() {
        return ReconnectEnum.fromValue(this.switchRunningMode);
    }

    public final String switchRunningModeAsString() {
        return this.switchRunningMode;
    }

    public final ReconnectEnum rebuildWorkspace() {
        return ReconnectEnum.fromValue(this.rebuildWorkspace);
    }

    public final String rebuildWorkspaceAsString() {
        return this.rebuildWorkspace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restartWorkspaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.increaseVolumeSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeComputeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.switchRunningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rebuildWorkspaceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfservicePermissions)) {
            return false;
        }
        SelfservicePermissions other = (SelfservicePermissions)obj;
        return Objects.equals(this.restartWorkspaceAsString(), other.restartWorkspaceAsString()) && Objects.equals(this.increaseVolumeSizeAsString(), other.increaseVolumeSizeAsString()) && Objects.equals(this.changeComputeTypeAsString(), other.changeComputeTypeAsString()) && Objects.equals(this.switchRunningModeAsString(), other.switchRunningModeAsString()) && Objects.equals(this.rebuildWorkspaceAsString(), other.rebuildWorkspaceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SelfservicePermissions").add("RestartWorkspace", (Object)this.restartWorkspaceAsString()).add("IncreaseVolumeSize", (Object)this.increaseVolumeSizeAsString()).add("ChangeComputeType", (Object)this.changeComputeTypeAsString()).add("SwitchRunningMode", (Object)this.switchRunningModeAsString()).add("RebuildWorkspace", (Object)this.rebuildWorkspaceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestartWorkspace": {
                return Optional.ofNullable(clazz.cast(this.restartWorkspaceAsString()));
            }
            case "IncreaseVolumeSize": {
                return Optional.ofNullable(clazz.cast(this.increaseVolumeSizeAsString()));
            }
            case "ChangeComputeType": {
                return Optional.ofNullable(clazz.cast(this.changeComputeTypeAsString()));
            }
            case "SwitchRunningMode": {
                return Optional.ofNullable(clazz.cast(this.switchRunningModeAsString()));
            }
            case "RebuildWorkspace": {
                return Optional.ofNullable(clazz.cast(this.rebuildWorkspaceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SelfservicePermissions, T> g) {
        return obj -> g.apply((SelfservicePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String restartWorkspace;
        private String increaseVolumeSize;
        private String changeComputeType;
        private String switchRunningMode;
        private String rebuildWorkspace;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfservicePermissions model) {
            this.restartWorkspace(model.restartWorkspace);
            this.increaseVolumeSize(model.increaseVolumeSize);
            this.changeComputeType(model.changeComputeType);
            this.switchRunningMode(model.switchRunningMode);
            this.rebuildWorkspace(model.rebuildWorkspace);
        }

        public final String getRestartWorkspace() {
            return this.restartWorkspace;
        }

        public final void setRestartWorkspace(String restartWorkspace) {
            this.restartWorkspace = restartWorkspace;
        }

        @Override
        public final Builder restartWorkspace(String restartWorkspace) {
            this.restartWorkspace = restartWorkspace;
            return this;
        }

        @Override
        public final Builder restartWorkspace(ReconnectEnum restartWorkspace) {
            this.restartWorkspace(restartWorkspace == null ? null : restartWorkspace.toString());
            return this;
        }

        public final String getIncreaseVolumeSize() {
            return this.increaseVolumeSize;
        }

        public final void setIncreaseVolumeSize(String increaseVolumeSize) {
            this.increaseVolumeSize = increaseVolumeSize;
        }

        @Override
        public final Builder increaseVolumeSize(String increaseVolumeSize) {
            this.increaseVolumeSize = increaseVolumeSize;
            return this;
        }

        @Override
        public final Builder increaseVolumeSize(ReconnectEnum increaseVolumeSize) {
            this.increaseVolumeSize(increaseVolumeSize == null ? null : increaseVolumeSize.toString());
            return this;
        }

        public final String getChangeComputeType() {
            return this.changeComputeType;
        }

        public final void setChangeComputeType(String changeComputeType) {
            this.changeComputeType = changeComputeType;
        }

        @Override
        public final Builder changeComputeType(String changeComputeType) {
            this.changeComputeType = changeComputeType;
            return this;
        }

        @Override
        public final Builder changeComputeType(ReconnectEnum changeComputeType) {
            this.changeComputeType(changeComputeType == null ? null : changeComputeType.toString());
            return this;
        }

        public final String getSwitchRunningMode() {
            return this.switchRunningMode;
        }

        public final void setSwitchRunningMode(String switchRunningMode) {
            this.switchRunningMode = switchRunningMode;
        }

        @Override
        public final Builder switchRunningMode(String switchRunningMode) {
            this.switchRunningMode = switchRunningMode;
            return this;
        }

        @Override
        public final Builder switchRunningMode(ReconnectEnum switchRunningMode) {
            this.switchRunningMode(switchRunningMode == null ? null : switchRunningMode.toString());
            return this;
        }

        public final String getRebuildWorkspace() {
            return this.rebuildWorkspace;
        }

        public final void setRebuildWorkspace(String rebuildWorkspace) {
            this.rebuildWorkspace = rebuildWorkspace;
        }

        @Override
        public final Builder rebuildWorkspace(String rebuildWorkspace) {
            this.rebuildWorkspace = rebuildWorkspace;
            return this;
        }

        @Override
        public final Builder rebuildWorkspace(ReconnectEnum rebuildWorkspace) {
            this.rebuildWorkspace(rebuildWorkspace == null ? null : rebuildWorkspace.toString());
            return this;
        }

        public SelfservicePermissions build() {
            return new SelfservicePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfservicePermissions> {
        public Builder restartWorkspace(String var1);

        public Builder restartWorkspace(ReconnectEnum var1);

        public Builder increaseVolumeSize(String var1);

        public Builder increaseVolumeSize(ReconnectEnum var1);

        public Builder changeComputeType(String var1);

        public Builder changeComputeType(ReconnectEnum var1);

        public Builder switchRunningMode(String var1);

        public Builder switchRunningMode(ReconnectEnum var1);

        public Builder rebuildWorkspace(String var1);

        public Builder rebuildWorkspace(ReconnectEnum var1);
    }
}

