/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.AccountLinkStatusEnum;
import software.amazon.awssdk.services.workspaces.model.LinkStatusFilterListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountLinksRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ListAccountLinksRequest> {
    private static final SdkField<List<String>> LINK_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkStatusFilter").getter(ListAccountLinksRequest.getter(ListAccountLinksRequest::linkStatusFilterAsStrings)).setter(ListAccountLinksRequest.setter(Builder::linkStatusFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkStatusFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccountLinksRequest.getter(ListAccountLinksRequest::nextToken)).setter(ListAccountLinksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAccountLinksRequest.getter(ListAccountLinksRequest::maxResults)).setter(ListAccountLinksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_STATUS_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LinkStatusFilter", LINK_STATUS_FILTER_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final List<String> linkStatusFilter;
    private final String nextToken;
    private final Integer maxResults;

    private ListAccountLinksRequest(BuilderImpl builder) {
        super(builder);
        this.linkStatusFilter = builder.linkStatusFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final List<AccountLinkStatusEnum> linkStatusFilter() {
        return LinkStatusFilterListCopier.copyStringToEnum(this.linkStatusFilter);
    }

    public final boolean hasLinkStatusFilter() {
        return this.linkStatusFilter != null && !(this.linkStatusFilter instanceof SdkAutoConstructList);
    }

    public final List<String> linkStatusFilterAsStrings() {
        return this.linkStatusFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkStatusFilter() ? this.linkStatusFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountLinksRequest)) {
            return false;
        }
        ListAccountLinksRequest other = (ListAccountLinksRequest)((Object)obj);
        return this.hasLinkStatusFilter() == other.hasLinkStatusFilter() && Objects.equals(this.linkStatusFilterAsStrings(), other.linkStatusFilterAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountLinksRequest").add("LinkStatusFilter", this.hasLinkStatusFilter() ? this.linkStatusFilterAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.linkStatusFilterAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountLinksRequest, T> g) {
        return obj -> g.apply((ListAccountLinksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> linkStatusFilter = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountLinksRequest model) {
            super(model);
            this.linkStatusFilterWithStrings(model.linkStatusFilter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getLinkStatusFilter() {
            if (this.linkStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkStatusFilter;
        }

        public final void setLinkStatusFilter(Collection<String> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copy(linkStatusFilter);
        }

        @Override
        public final Builder linkStatusFilterWithStrings(Collection<String> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copy(linkStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkStatusFilterWithStrings(String ... linkStatusFilter) {
            this.linkStatusFilterWithStrings(Arrays.asList(linkStatusFilter));
            return this;
        }

        @Override
        public final Builder linkStatusFilter(Collection<AccountLinkStatusEnum> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copyEnumToString(linkStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkStatusFilter(AccountLinkStatusEnum ... linkStatusFilter) {
            this.linkStatusFilter(Arrays.asList(linkStatusFilter));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountLinksRequest build() {
            return new ListAccountLinksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountLinksRequest> {
        public Builder linkStatusFilterWithStrings(Collection<String> var1);

        public Builder linkStatusFilterWithStrings(String ... var1);

        public Builder linkStatusFilter(Collection<AccountLinkStatusEnum> var1);

        public Builder linkStatusFilter(AccountLinkStatusEnum ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

