/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.BundleIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceBundlesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspaceBundlesRequest> {
    private static final SdkField<List<String>> BUNDLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BundleIds").getter(DescribeWorkspaceBundlesRequest.getter(DescribeWorkspaceBundlesRequest::bundleIds)).setter(DescribeWorkspaceBundlesRequest.setter(Builder::bundleIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(DescribeWorkspaceBundlesRequest.getter(DescribeWorkspaceBundlesRequest::owner)).setter(DescribeWorkspaceBundlesRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspaceBundlesRequest.getter(DescribeWorkspaceBundlesRequest::nextToken)).setter(DescribeWorkspaceBundlesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_IDS_FIELD, OWNER_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BundleIds", BUNDLE_IDS_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> bundleIds;
    private final String owner;
    private final String nextToken;

    private DescribeWorkspaceBundlesRequest(BuilderImpl builder) {
        super(builder);
        this.bundleIds = builder.bundleIds;
        this.owner = builder.owner;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBundleIds() {
        return this.bundleIds != null && !(this.bundleIds instanceof SdkAutoConstructList);
    }

    public final List<String> bundleIds() {
        return this.bundleIds;
    }

    public final String owner() {
        return this.owner;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleIds() ? this.bundleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceBundlesRequest)) {
            return false;
        }
        DescribeWorkspaceBundlesRequest other = (DescribeWorkspaceBundlesRequest)((Object)obj);
        return this.hasBundleIds() == other.hasBundleIds() && Objects.equals(this.bundleIds(), other.bundleIds()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceBundlesRequest").add("BundleIds", this.hasBundleIds() ? this.bundleIds() : null).add("Owner", (Object)this.owner()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleIds": {
                return Optional.ofNullable(clazz.cast(this.bundleIds()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceBundlesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceBundlesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> bundleIds = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceBundlesRequest model) {
            super(model);
            this.bundleIds(model.bundleIds);
            this.owner(model.owner);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getBundleIds() {
            if (this.bundleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bundleIds;
        }

        public final void setBundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdListCopier.copy(bundleIds);
        }

        @Override
        public final Builder bundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdListCopier.copy(bundleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleIds(String ... bundleIds) {
            this.bundleIds(Arrays.asList(bundleIds));
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceBundlesRequest build() {
            return new DescribeWorkspaceBundlesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceBundlesRequest> {
        public Builder bundleIds(Collection<String> var1);

        public Builder bundleIds(String ... var1);

        public Builder owner(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

