/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspaces.model.LoginMessageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultClientBrandingAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultClientBrandingAttributes> {
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogoUrl").getter(DefaultClientBrandingAttributes.getter(DefaultClientBrandingAttributes::logoUrl)).setter(DefaultClientBrandingAttributes.setter(Builder::logoUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(DefaultClientBrandingAttributes.getter(DefaultClientBrandingAttributes::supportEmail)).setter(DefaultClientBrandingAttributes.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportLink").getter(DefaultClientBrandingAttributes.getter(DefaultClientBrandingAttributes::supportLink)).setter(DefaultClientBrandingAttributes.setter(Builder::supportLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLink").build()}).build();
    private static final SdkField<String> FORGOT_PASSWORD_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForgotPasswordLink").getter(DefaultClientBrandingAttributes.getter(DefaultClientBrandingAttributes::forgotPasswordLink)).setter(DefaultClientBrandingAttributes.setter(Builder::forgotPasswordLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForgotPasswordLink").build()}).build();
    private static final SdkField<Map<String, String>> LOGIN_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LoginMessage").getter(DefaultClientBrandingAttributes.getter(DefaultClientBrandingAttributes::loginMessage)).setter(DefaultClientBrandingAttributes.setter(Builder::loginMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginMessage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_URL_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_LINK_FIELD, FORGOT_PASSWORD_LINK_FIELD, LOGIN_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LogoUrl", LOGO_URL_FIELD);
            this.put("SupportEmail", SUPPORT_EMAIL_FIELD);
            this.put("SupportLink", SUPPORT_LINK_FIELD);
            this.put("ForgotPasswordLink", FORGOT_PASSWORD_LINK_FIELD);
            this.put("LoginMessage", LOGIN_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String logoUrl;
    private final String supportEmail;
    private final String supportLink;
    private final String forgotPasswordLink;
    private final Map<String, String> loginMessage;

    private DefaultClientBrandingAttributes(BuilderImpl builder) {
        this.logoUrl = builder.logoUrl;
        this.supportEmail = builder.supportEmail;
        this.supportLink = builder.supportLink;
        this.forgotPasswordLink = builder.forgotPasswordLink;
        this.loginMessage = builder.loginMessage;
    }

    public final String logoUrl() {
        return this.logoUrl;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportLink() {
        return this.supportLink;
    }

    public final String forgotPasswordLink() {
        return this.forgotPasswordLink;
    }

    public final boolean hasLoginMessage() {
        return this.loginMessage != null && !(this.loginMessage instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> loginMessage() {
        return this.loginMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.forgotPasswordLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoginMessage() ? this.loginMessage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClientBrandingAttributes)) {
            return false;
        }
        DefaultClientBrandingAttributes other = (DefaultClientBrandingAttributes)obj;
        return Objects.equals(this.logoUrl(), other.logoUrl()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportLink(), other.supportLink()) && Objects.equals(this.forgotPasswordLink(), other.forgotPasswordLink()) && this.hasLoginMessage() == other.hasLoginMessage() && Objects.equals(this.loginMessage(), other.loginMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultClientBrandingAttributes").add("LogoUrl", (Object)this.logoUrl()).add("SupportEmail", (Object)this.supportEmail()).add("SupportLink", (Object)this.supportLink()).add("ForgotPasswordLink", (Object)this.forgotPasswordLink()).add("LoginMessage", this.hasLoginMessage() ? this.loginMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogoUrl": {
                return Optional.ofNullable(clazz.cast(this.logoUrl()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportLink": {
                return Optional.ofNullable(clazz.cast(this.supportLink()));
            }
            case "ForgotPasswordLink": {
                return Optional.ofNullable(clazz.cast(this.forgotPasswordLink()));
            }
            case "LoginMessage": {
                return Optional.ofNullable(clazz.cast(this.loginMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultClientBrandingAttributes, T> g) {
        return obj -> g.apply((DefaultClientBrandingAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logoUrl;
        private String supportEmail;
        private String supportLink;
        private String forgotPasswordLink;
        private Map<String, String> loginMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultClientBrandingAttributes model) {
            this.logoUrl(model.logoUrl);
            this.supportEmail(model.supportEmail);
            this.supportLink(model.supportLink);
            this.forgotPasswordLink(model.forgotPasswordLink);
            this.loginMessage(model.loginMessage);
        }

        public final String getLogoUrl() {
            return this.logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportLink() {
            return this.supportLink;
        }

        public final void setSupportLink(String supportLink) {
            this.supportLink = supportLink;
        }

        @Override
        public final Builder supportLink(String supportLink) {
            this.supportLink = supportLink;
            return this;
        }

        public final String getForgotPasswordLink() {
            return this.forgotPasswordLink;
        }

        public final void setForgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
        }

        @Override
        public final Builder forgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
            return this;
        }

        public final Map<String, String> getLoginMessage() {
            if (this.loginMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.loginMessage;
        }

        public final void setLoginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
        }

        @Override
        public final Builder loginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
            return this;
        }

        public DefaultClientBrandingAttributes build() {
            return new DefaultClientBrandingAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultClientBrandingAttributes> {
        public Builder logoUrl(String var1);

        public Builder supportEmail(String var1);

        public Builder supportLink(String var1);

        public Builder forgotPasswordLink(String var1);

        public Builder loginMessage(Map<String, String> var1);
    }
}

